set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7704944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2044301',
      1.907538,
      NULL,
      NULL,
      3.253369,
      3,
      5.975501,
      3.927828,
      5,
      1,
      1.545912,
      1,
      1.152912,
      1,
      0.822752,
      1,
      1.541836,
      0,
      1,
      3.841082,
      2,
      1,
      0.072983,
      0.705855,
      3.118880,
      1.689066,
      2.452700,
      NULL,
      0.434545,
      NULL,
      1,
      0.902411,
      0,
      NULL,
      1,
      1,
      1.883434,
      0,
      0,
      0.205443,
      0.171049,
      NULL,
      NULL,
      2.436547,
      1,
      1,
      0,
      0.698545,
      0,
      0,
      1.074488,
      0,
      0,
      1,
      1.237809,
      1.995578,
      NULL,
      0.055533,
      1,
      3.213398,
      1.483511,
      1,
      NULL,
      NULL,
      0.019502,
      1.858113,
      NULL,
      0.500550,
      NULL,
      0.882644,
      NULL,
      NULL,
      NULL,
      2.808873,
      NULL,
      NULL,
      2.633318,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.072100,
      1.489639,
      1,
      NULL,
      NULL,
      2.543917,
      1,
      1.029634,
      0.770736,
      0.177449,
      NULL,
      3,
      2,
      2.471110,
      0.729350,
      NULL,
      3.220519,
      1,
      10,
      NULL,
      '',
      '',
      ' 9-17-1990');
commit;
end;
/


