set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6802799';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0413141',
      3,
      3,
      20,
      NULL,
      0,
      3,
      NULL,
      59,
      NULL,
      1,
      1.034751,
      1,
      3,
      0,
      0,
      NULL,
      1.810738,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.663914,
      NULL,
      1.453548,
      2.403850,
      0,
      2.163746,
      1,
      1.797042,
      1,
      0.252920,
      1,
      NULL,
      1.340927,
      0,
      0,
      2.785441,
      3,
      0,
      0.305449,
      3,
      0.977137,
      2,
      1,
      3.524069,
      1.509664,
      2,
      0,
      1.753704,
      0.141474,
      1.342569,
      1,
      1.534951,
      NULL,
      2,
      2.585886,
      NULL,
      0,
      0,
      0,
      1,
      1.469329,
      0,
      0.006748,
      1,
      NULL,
      NULL,
      0,
      1.954241,
      1,
      1,
      0.099532,
      0,
      0,
      2,
      1,
      1.228846,
      1,
      NULL,
      0.571981,
      0.990305,
      1,
      0.570724,
      0,
      NULL,
      1.378503,
      0.037045,
      NULL,
      0,
      3.771530,
      3.616825,
      1.574553,
      0,
      NULL,
      0.883819,
      3,
      2.200625,
      1.807761,
      1.834276,
      1,
      NULL,
      NULL,
      3,
      '',
      '',
      NULL);
commit;
end;
/


