set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8907347';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      2,
      10.161656,
      2,
      NULL,
      NULL,
      NULL,
      61.031973,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      0.177143,
      0.886235,
      1,
      NULL,
      0,
      0,
      2,
      1,
      2,
      1.466623,
      2.627438,
      1.667317,
      1,
      0.614045,
      3.732048,
      1,
      0.292841,
      0,
      1.817096,
      0.949498,
      1.424470,
      1,
      NULL,
      1,
      NULL,
      3.685421,
      NULL,
      2,
      NULL,
      0.262448,
      0.372085,
      NULL,
      3,
      0,
      2,
      NULL,
      1.175530,
      0.570600,
      1.169943,
      0.797975,
      1.011390,
      0,
      1.874138,
      1.259214,
      3,
      0.313784,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.206580,
      1.347362,
      NULL,
      1.783824,
      0.223215,
      0.501993,
      NULL,
      0.351769,
      1.903829,
      0.554598,
      0,
      NULL,
      0.217456,
      1.100932,
      1.327086,
      NULL,
      0.601315,
      1.958256,
      0.248725,
      1,
      1,
      0,
      1.281474,
      NULL,
      NULL,
      1.972440,
      2,
      NULL,
      1,
      NULL,
      1.515525,
      0,
      NULL,
      0.831854,
      2,
      3,
      0,
      0.233181,
      9.680476,
      NULL,
      '',
      NULL,
      ' 0-11-1990');
commit;
end;
/


