set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.262266,
      3,
      0.835811,
      3.892809,
      NULL,
      NULL,
      NULL,
      69,
      NULL,
      2,
      3.502402,
      0.210082,
      0.249056,
      0,
      1.687169,
      0.167521,
      0.831106,
      0,
      1.192931,
      1,
      0.486407,
      1.326935,
      1,
      NULL,
      0.455047,
      2.164030,
      NULL,
      0,
      NULL,
      2.082096,
      0.052362,
      1.837619,
      0.494469,
      1.066919,
      0.557856,
      2,
      0,
      2.649389,
      0.546370,
      0,
      NULL,
      2,
      0.683728,
      NULL,
      1.129690,
      NULL,
      1.983212,
      NULL,
      0,
      1.803281,
      0.541510,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0.925878,
      2,
      1,
      NULL,
      1,
      1,
      1.002829,
      2.509850,
      1.993868,
      0.111367,
      1,
      1,
      0,
      1,
      2.267245,
      2,
      1,
      1,
      1.276324,
      0,
      0,
      1,
      1,
      1,
      1.669950,
      0.173071,
      0.913642,
      3.738334,
      0.185720,
      1,
      0.191623,
      0.319509,
      3.857312,
      NULL,
      0.714503,
      1.273884,
      0.465107,
      1.255960,
      2,
      1,
      2,
      3,
      3,
      2,
      0.281124,
      0,
      0,
      0,
      '',
      '',
      ' 5-14-1991');
commit;
end;
/


