set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000230';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0141040',
      0.923256,
      NULL,
      NULL,
      3,
      1,
      4,
      10.860588,
      NULL,
      1.924312,
      3,
      3.314776,
      1.992592,
      3,
      2.651060,
      NULL,
      0.747080,
      1,
      1.804390,
      1,
      1,
      1,
      1.966395,
      0,
      1.819491,
      0,
      1,
      0.964926,
      1,
      0.481490,
      3.319931,
      0,
      3,
      NULL,
      1.196046,
      0.367669,
      2,
      1.964725,
      0.046503,
      1.473194,
      NULL,
      0.644191,
      1,
      1.470999,
      3.665867,
      NULL,
      2.213131,
      1.868589,
      2.255624,
      0,
      3.316406,
      1,
      0.101256,
      1.503224,
      1.566953,
      1.534305,
      0,
      1,
      0,
      2,
      1.554421,
      NULL,
      0,
      0,
      1.728904,
      0,
      3,
      0,
      2,
      1.911433,
      0.875108,
      1,
      NULL,
      0.728337,
      1.157276,
      0,
      3,
      1,
      3,
      0,
      1,
      0,
      NULL,
      1.753066,
      2.733255,
      1,
      0.775352,
      0,
      NULL,
      NULL,
      1,
      1,
      0.740281,
      0,
      1,
      1.225049,
      0.558324,
      2,
      0,
      1.689502,
      2.785183,
      1,
      1,
      0,
      0.519451,
      2.775716,
      10.896784,
      NULL,
      '421',
      '11-24-1993');
commit;
end;
/


