set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8520583';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2200432',
      NULL,
      1,
      16.804679,
      2.589579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.573045,
      NULL,
      1,
      0,
      1.538427,
      0.698288,
      0,
      1.071185,
      3,
      2.150085,
      NULL,
      2.476015,
      NULL,
      0,
      0.204861,
      NULL,
      0.620255,
      NULL,
      1.916215,
      1,
      0,
      0.175785,
      0,
      0.085456,
      0,
      1.441044,
      0.943285,
      1.599863,
      NULL,
      NULL,
      0,
      0.358965,
      2,
      1,
      0.122401,
      1.550370,
      0.648026,
      1,
      1.825590,
      2.753433,
      NULL,
      1,
      0.658262,
      3,
      1.224028,
      0,
      1.308176,
      0.777664,
      2,
      NULL,
      1.848062,
      1,
      1,
      1,
      NULL,
      1.850584,
      NULL,
      0.908235,
      0.653731,
      1,
      0,
      NULL,
      2,
      1,
      NULL,
      0.050306,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0.080572,
      1.168999,
      0.774685,
      1.512059,
      1.886576,
      1.684830,
      0,
      NULL,
      0,
      1,
      0.213455,
      0,
      0,
      1.537550,
      1.994162,
      3.882122,
      0,
      2,
      0,
      NULL,
      31,
      3.478768,
      NULL,
      '',
      ' 9-26-1974');
commit;
end;
/


