set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816137';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3403002',
      2,
      0,
      15.156343,
      1.013019,
      2,
      5,
      4,
      36,
      0,
      0.828883,
      1.903971,
      1.673055,
      3,
      1,
      2,
      0,
      NULL,
      0.121011,
      1,
      0,
      1,
      1.614789,
      1,
      1,
      0.063668,
      NULL,
      0,
      1.318551,
      0,
      3.203131,
      1,
      1,
      1.366473,
      0.751359,
      NULL,
      1.666398,
      1,
      1.293801,
      0.210423,
      3.869853,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      1.914285,
      1,
      0.813297,
      1.594298,
      0,
      NULL,
      1,
      0,
      0.669606,
      1.496833,
      1.475233,
      0.057974,
      0,
      0,
      0,
      1.772501,
      0,
      0.936417,
      3.198819,
      0,
      NULL,
      NULL,
      1.766381,
      1.208037,
      1.547821,
      0.389199,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.910382,
      1,
      1.045323,
      0,
      0,
      NULL,
      1.846282,
      0,
      1.150602,
      1,
      0.140160,
      3.232985,
      2,
      1,
      1.777230,
      0,
      1.985092,
      0.818414,
      NULL,
      NULL,
      3.911308,
      1,
      3.277617,
      NULL,
      NULL,
      5,
      '',
      '',
      NULL);
commit;
end;
/


