set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0,
      2,
      NULL,
      3,
      1,
      2.635324,
      19.887925,
      NULL,
      NULL,
      1.719589,
      NULL,
      2.119389,
      2.449144,
      1.587697,
      1,
      NULL,
      NULL,
      1.188696,
      2.119222,
      0.933033,
      0.243856,
      3.508542,
      0,
      2,
      1,
      1,
      0.797367,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1.693172,
      NULL,
      NULL,
      0.804038,
      0,
      1.829187,
      2,
      3,
      0.382231,
      3,
      0.654945,
      0.803799,
      0.947783,
      NULL,
      NULL,
      NULL,
      3.269723,
      0.441789,
      0,
      0,
      0.287592,
      NULL,
      1.789960,
      0,
      0.774610,
      3,
      NULL,
      1,
      0.988661,
      NULL,
      1,
      0,
      NULL,
      1.653002,
      0.304673,
      0,
      0,
      1.999147,
      0.949371,
      0,
      NULL,
      NULL,
      0.600751,
      NULL,
      NULL,
      1.132157,
      0.295843,
      1,
      0.104889,
      0.813809,
      NULL,
      1,
      1,
      1.737415,
      0.216997,
      0.376891,
      1,
      0,
      1,
      0,
      1.786443,
      0,
      0,
      2,
      1.814006,
      3.074834,
      NULL,
      2,
      2.259442,
      1.528489,
      NULL,
      NULL,
      0,
      NULL,
      '322',
      '11-23-1996');
commit;
end;
/


