set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000214';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202202',
      NULL,
      2,
      NULL,
      3,
      0,
      0,
      45,
      50.948606,
      NULL,
      1,
      1.503698,
      0,
      0.479995,
      1,
      2,
      NULL,
      1.989839,
      1,
      0,
      0.354076,
      NULL,
      0,
      0,
      2,
      1.640336,
      0,
      NULL,
      1,
      0,
      NULL,
      0.982815,
      0.330110,
      1.442330,
      1.613589,
      1,
      3.084307,
      0.160170,
      0.025902,
      0.657203,
      3.168365,
      0,
      1,
      3.325387,
      NULL,
      NULL,
      NULL,
      1.240508,
      0.807432,
      0,
      NULL,
      0,
      2.312165,
      1,
      1.196625,
      0.807545,
      2.518154,
      1.227409,
      NULL,
      3.446869,
      0,
      0,
      1.627611,
      0.081887,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      1.134156,
      1.709128,
      2.851820,
      0,
      0.860518,
      1,
      0,
      NULL,
      NULL,
      1,
      0.275397,
      1,
      1,
      1,
      1,
      0.663606,
      0.387955,
      1,
      0,
      NULL,
      1.022036,
      3,
      0.087872,
      1,
      0.044515,
      2,
      0.434245,
      0,
      1,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      '',
      NULL,
      ' 0- 4-1986');
commit;
end;
/


