set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000107';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1,
      NULL,
      2,
      2.018811,
      0.360222,
      0,
      8.377450,
      20.085069,
      NULL,
      3.475893,
      1,
      1.669814,
      NULL,
      1.592105,
      NULL,
      2.046424,
      0,
      1,
      0.210936,
      1,
      0,
      2.909581,
      1,
      NULL,
      0.079574,
      3.464861,
      NULL,
      0,
      0.423483,
      1,
      1.611262,
      0.055237,
      1.673168,
      0.750941,
      NULL,
      NULL,
      0.074929,
      0.104008,
      1.737894,
      0,
      1,
      NULL,
      NULL,
      3.253756,
      0,
      1.826039,
      0.380325,
      2,
      1,
      0.797382,
      1,
      NULL,
      1,
      0.885528,
      NULL,
      0,
      0.504581,
      0.666982,
      3.172991,
      NULL,
      0,
      0.305419,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748098,
      0.628178,
      NULL,
      0,
      1.095454,
      1.077256,
      NULL,
      0,
      1,
      NULL,
      1.796668,
      0.130460,
      1,
      1,
      NULL,
      0.166835,
      1,
      0,
      1,
      NULL,
      1.438894,
      NULL,
      NULL,
      1,
      1.496706,
      3.266329,
      2.297286,
      NULL,
      1.063602,
      0.584471,
      0,
      0,
      NULL,
      NULL,
      0.960437,
      1.432657,
      3,
      0.562122,
      7.636683,
      4,
      '',
      '',
      '11-23-1991');
commit;
end;
/


