set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1031023',
      NULL,
      1,
      NULL,
      3.976046,
      0.035211,
      2.769107,
      31.438997,
      114.778560,
      NULL,
      1.180975,
      0,
      0.906988,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0.986429,
      0,
      1,
      1,
      1.855706,
      1,
      0.928830,
      1.738529,
      0.638014,
      0.610669,
      1,
      NULL,
      1,
      1.550469,
      0,
      2,
      0,
      NULL,
      1.675901,
      3,
      2.393391,
      1.872751,
      NULL,
      3,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      1.629909,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.765506,
      0,
      0,
      0.248853,
      0,
      0,
      NULL,
      3.828123,
      1.903854,
      1,
      1.862184,
      1,
      0.861941,
      NULL,
      0.046946,
      1.315558,
      0.550647,
      1,
      1,
      0.135249,
      1,
      0,
      0.413315,
      1.348801,
      0.269555,
      1.283175,
      NULL,
      0.850411,
      NULL,
      1.686135,
      0,
      1.399568,
      3.297401,
      0.230919,
      1,
      0,
      3,
      0.543685,
      0,
      3,
      1.996255,
      2,
      1.857183,
      1,
      0.878158,
      1.215466,
      NULL,
      '020',
      ' 9- 8-1981');
commit;
end;
/


