set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000182';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2413342',
      NULL,
      0,
      11.488761,
      3.286919,
      NULL,
      NULL,
      NULL,
      58.650312,
      1,
      2,
      0,
      NULL,
      2.216460,
      1,
      0.916438,
      3,
      NULL,
      0,
      3,
      0.443859,
      1.503779,
      2.351377,
      0,
      3,
      1,
      2.011067,
      1.210619,
      1,
      1.403551,
      2,
      0,
      1,
      0.508102,
      NULL,
      0,
      2.217993,
      0.457766,
      1,
      0,
      2.611484,
      3,
      3,
      NULL,
      1.301907,
      0.180293,
      2,
      1,
      NULL,
      NULL,
      2.344203,
      1.056499,
      0.298389,
      1.524499,
      0,
      1.405690,
      1,
      0.386883,
      1.020898,
      2.913697,
      2,
      0,
      0.391286,
      NULL,
      0,
      1.084052,
      3.032228,
      1.612154,
      1,
      1,
      0,
      1,
      1,
      2,
      0,
      1.129568,
      NULL,
      1,
      1.140276,
      1.087706,
      1,
      1,
      NULL,
      1,
      1.168428,
      0,
      NULL,
      NULL,
      0,
      0,
      0.124978,
      0.974632,
      1,
      3.058135,
      1.860231,
      NULL,
      0,
      3.095005,
      NULL,
      1.014929,
      3,
      1,
      3.376105,
      NULL,
      1,
      8,
      3,
      NULL,
      '',
      NULL);
commit;
end;
/


