set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9209266';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2032320',
      0.866848,
      3,
      10,
      0.265921,
      NULL,
      NULL,
      NULL,
      55,
      0,
      0.964637,
      2,
      0,
      1.898524,
      1.920693,
      NULL,
      0,
      0,
      1.177779,
      NULL,
      0.393939,
      0,
      3,
      1.358147,
      1.378950,
      0.801436,
      2.803911,
      3,
      NULL,
      1.671512,
      3.238530,
      3,
      1.144052,
      1.313487,
      1.066900,
      1,
      NULL,
      1,
      1.948335,
      NULL,
      0.645412,
      NULL,
      NULL,
      3.138246,
      0.425377,
      1,
      2,
      0.651060,
      NULL,
      NULL,
      3.863913,
      1.261801,
      NULL,
      1,
      0,
      1,
      1.191416,
      1,
      0,
      NULL,
      3.667060,
      1.662985,
      0.525682,
      1.914471,
      0.609022,
      0,
      3,
      1,
      1.597205,
      1.947425,
      0.839333,
      1.609116,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0.732952,
      1,
      0.289992,
      0.364954,
      0,
      0,
      0.369388,
      0.778113,
      2,
      NULL,
      0.187360,
      NULL,
      1,
      1.252630,
      2,
      0.861623,
      1,
      1,
      0.205107,
      0.063512,
      0.113874,
      1.511638,
      0.829807,
      1,
      2.239492,
      0,
      NULL,
      NULL,
      '403',
      '04',
      NULL);
commit;
end;
/


