set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7602143';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2434004',
      0.436988,
      NULL,
      21,
      NULL,
      3,
      4,
      10.769250,
      NULL,
      1.995006,
      2.613621,
      0.469164,
      NULL,
      1.692974,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.922822,
      1.462948,
      0,
      0.427414,
      3.130677,
      1.760142,
      1.496808,
      NULL,
      1,
      1.743157,
      3.186550,
      1.465809,
      3.397026,
      0,
      1,
      0.073750,
      1.762248,
      1.767589,
      0.632156,
      1.213507,
      1.498105,
      0,
      3,
      0,
      0.240059,
      1,
      1,
      0.812681,
      0.874180,
      1,
      0.748431,
      0,
      0.913896,
      NULL,
      0,
      0.527541,
      NULL,
      NULL,
      0.467669,
      0.896558,
      NULL,
      0,
      0.626473,
      0,
      0,
      NULL,
      3.608075,
      NULL,
      0,
      1,
      0,
      1,
      1.587566,
      0,
      2,
      0.226985,
      1.922120,
      1.686319,
      0.686181,
      0,
      0.056805,
      NULL,
      1.794619,
      0,
      1.335140,
      1.977357,
      1.078430,
      0,
      0.191876,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0.725967,
      0.888048,
      0.719958,
      NULL,
      1,
      NULL,
      NULL,
      2.864013,
      NULL,
      NULL,
      7,
      2,
      NULL,
      '',
      ' 0-16-1988');
commit;
end;
/


