set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      14.973985,
      1.586953,
      0,
      NULL,
      NULL,
      75.650980,
      1.919803,
      0.001122,
      0,
      2.238866,
      1,
      1,
      3.940860,
      1.283510,
      1,
      1.884391,
      0.564776,
      NULL,
      0.384294,
      1.349296,
      1,
      3.258836,
      0,
      3.698372,
      NULL,
      NULL,
      0,
      2.948438,
      NULL,
      0.389402,
      0,
      0.325461,
      NULL,
      3.773346,
      0.429509,
      1,
      0,
      1,
      1.132334,
      NULL,
      1,
      NULL,
      1.284850,
      3.268676,
      1.361791,
      1,
      0.519428,
      0.602510,
      0.947472,
      0,
      1,
      1.634036,
      1,
      NULL,
      1.239748,
      NULL,
      0,
      NULL,
      NULL,
      1.285317,
      NULL,
      1.468834,
      0.221396,
      1.314927,
      3,
      NULL,
      1.700801,
      NULL,
      1,
      1,
      1.621341,
      NULL,
      0.759031,
      NULL,
      1.881166,
      1.578789,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0.533338,
      1.165080,
      1.184549,
      1,
      0.998074,
      NULL,
      0,
      NULL,
      0.967739,
      2,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      ' 0- 8-1994');
commit;
end;
/


