set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000173';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3013220',
      3,
      2,
      34,
      0.124044,
      0,
      2,
      36,
      NULL,
      0,
      NULL,
      3.635742,
      1,
      NULL,
      1,
      1.749090,
      3.070969,
      0,
      NULL,
      2.599211,
      1,
      1,
      NULL,
      0,
      3.995668,
      0.477486,
      0.010638,
      1.104498,
      0.452706,
      1,
      3,
      0.171275,
      NULL,
      1,
      1.265359,
      0.006703,
      3.886439,
      0.195973,
      0.843076,
      0.604285,
      1,
      0.723618,
      3.592775,
      2,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      3,
      0.743075,
      1.735570,
      1,
      1,
      0.527071,
      NULL,
      0.456681,
      1,
      3.975576,
      0.737615,
      1.910589,
      1,
      1,
      1.958597,
      0,
      1,
      0.867823,
      0.013133,
      0.148434,
      1.637638,
      1.637132,
      1,
      2,
      NULL,
      NULL,
      1,
      0.923267,
      0.753371,
      0,
      0,
      1.021710,
      1,
      0.803238,
      0.343279,
      0.170038,
      3,
      0.007958,
      2,
      NULL,
      1,
      NULL,
      0,
      3.747943,
      0.932566,
      1.978649,
      NULL,
      2.092512,
      1,
      0.957727,
      NULL,
      0,
      3,
      2,
      NULL,
      0.196357,
      1.548176,
      '',
      '',
      NULL);
commit;
end;
/


