set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6414280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2211440',
      NULL,
      NULL,
      NULL,
      1,
      3.673705,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.740707,
      1.175877,
      0,
      3,
      0,
      3.234351,
      3.873151,
      0.089325,
      2.701021,
      0.281263,
      0.203956,
      1,
      1.291068,
      1,
      0,
      1,
      0,
      0,
      0.993603,
      NULL,
      2,
      0.612107,
      0,
      0,
      0.097721,
      1,
      0.056985,
      0,
      2,
      0.893548,
      NULL,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0,
      1.280374,
      NULL,
      0.626213,
      1.493322,
      NULL,
      3.326733,
      1.980864,
      1,
      1.153398,
      1,
      NULL,
      NULL,
      NULL,
      1.217845,
      3,
      0.615534,
      NULL,
      NULL,
      0,
      NULL,
      3.420196,
      0.239940,
      0.201371,
      NULL,
      1,
      0,
      0.543243,
      1,
      NULL,
      1,
      1.422341,
      0.638116,
      1.979200,
      1.011039,
      1.809780,
      1,
      1,
      0,
      0,
      2,
      NULL,
      0,
      0.315266,
      1,
      1.733025,
      3.732579,
      NULL,
      1,
      1,
      2,
      0,
      13,
      NULL,
      '',
      '',
      '11-13-1977');
commit;
end;
/


