set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9235780';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2344312',
      0.300050,
      NULL,
      34,
      0.501481,
      1.523730,
      NULL,
      NULL,
      43.557727,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.322628,
      2,
      1.129317,
      1.506387,
      0,
      NULL,
      1,
      NULL,
      0.216608,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0.135291,
      3.241369,
      1.618564,
      0.478224,
      NULL,
      1.530886,
      0,
      2,
      0.360996,
      0.331568,
      1,
      NULL,
      1,
      1.593178,
      NULL,
      2,
      NULL,
      1.313460,
      NULL,
      0.786849,
      1.410713,
      NULL,
      1.576143,
      NULL,
      0.189106,
      0.598515,
      NULL,
      NULL,
      NULL,
      0,
      2.421444,
      0.164311,
      NULL,
      0,
      1.302817,
      1,
      NULL,
      0,
      0.865408,
      0.272513,
      1.335489,
      2,
      1,
      NULL,
      1.202744,
      0,
      0.200823,
      0.154759,
      1,
      1.050639,
      1,
      0.652341,
      0,
      NULL,
      0.617090,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      2.141417,
      2.203716,
      1.462990,
      1,
      0,
      2,
      0,
      0,
      1.916775,
      1,
      2,
      3.596519,
      0,
      3,
      3,
      '002',
      '410',
      ' 0- 9-1980');
commit;
end;
/


