set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4022210',
      0.276834,
      NULL,
      5,
      3,
      2,
      2.769593,
      74,
      100.104351,
      1,
      NULL,
      2.436294,
      2.468652,
      1,
      NULL,
      2,
      0.107577,
      0,
      0.850153,
      0.017440,
      0,
      0,
      NULL,
      0.942358,
      NULL,
      0,
      1.300085,
      1,
      1,
      0.518226,
      1.279178,
      1.814141,
      1,
      0,
      1.413915,
      0.724375,
      1,
      0,
      0.256567,
      0.867480,
      NULL,
      1.094844,
      3,
      NULL,
      NULL,
      NULL,
      3.427567,
      0,
      3.206965,
      1,
      2.582136,
      1,
      1,
      0.651763,
      1,
      0,
      1,
      1,
      0.915061,
      2,
      0,
      1.113626,
      1.634067,
      0,
      1.178694,
      NULL,
      0,
      1.162513,
      NULL,
      1,
      1,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      0.438509,
      1,
      1,
      0.544512,
      1,
      0.374387,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      0.387494,
      1,
      3.025394,
      0.113365,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.726255,
      3,
      0,
      2,
      1,
      2,
      1.136052,
      '411',
      NULL,
      '10-17-1979');
commit;
end;
/


