set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7128421';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4201444',
      3.053835,
      NULL,
      25,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101202,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.586791,
      0,
      0.477177,
      0.054997,
      0.100566,
      1.282168,
      3,
      1.396604,
      0.674200,
      1,
      NULL,
      1.846743,
      0,
      1.134622,
      0.811865,
      1,
      NULL,
      1.166096,
      1.718752,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0.949094,
      0.208207,
      1,
      NULL,
      1.773444,
      1,
      0.445271,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      0,
      2.693472,
      NULL,
      1,
      0.860651,
      0.278407,
      0.595075,
      3,
      0.549922,
      0.480699,
      NULL,
      0.921186,
      0,
      NULL,
      0.961901,
      1,
      NULL,
      NULL,
      0.042721,
      1.615644,
      NULL,
      1.291953,
      0.610841,
      NULL,
      1.576662,
      0.100582,
      0.620651,
      NULL,
      0.382905,
      0,
      3,
      1,
      1,
      NULL,
      0.263399,
      1.271864,
      0,
      0.906812,
      2,
      1.274896,
      '103',
      '411',
      NULL);
commit;
end;
/


