set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804327';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2142013',
      NULL,
      2,
      26.799083,
      NULL,
      0.928996,
      NULL,
      NULL,
      38,
      NULL,
      1.703362,
      0.782584,
      3.665117,
      2,
      0,
      NULL,
      NULL,
      1.834515,
      1,
      1,
      0,
      0.491188,
      3,
      0.600697,
      NULL,
      0.807729,
      0,
      0.431147,
      1,
      NULL,
      1,
      2,
      NULL,
      1.709026,
      0.828648,
      0.427704,
      1,
      1.007635,
      1.882166,
      0,
      3,
      NULL,
      0.584405,
      2,
      1.030936,
      0,
      NULL,
      NULL,
      0.227881,
      0.373007,
      3.173433,
      1,
      1.594579,
      1,
      0,
      1.598672,
      0.410793,
      NULL,
      1.895227,
      0.183168,
      3.366179,
      NULL,
      0,
      0,
      1.538408,
      0.212236,
      3.654240,
      3,
      2,
      1,
      0,
      0,
      NULL,
      0.622154,
      NULL,
      1.662491,
      0,
      NULL,
      NULL,
      1.706094,
      0.773581,
      1,
      0,
      0.100025,
      0.140314,
      1,
      NULL,
      0,
      1.936248,
      1,
      NULL,
      3.783133,
      1.476702,
      1,
      1,
      3,
      NULL,
      NULL,
      0,
      0,
      0.520005,
      2.473164,
      0.991085,
      2,
      1.372268,
      12.345711,
      1.047105,
      NULL,
      '',
      '10-12-1987');
commit;
end;
/


