set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019289';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      0.516282,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      42,
      NULL,
      1,
      1,
      3,
      2,
      0.077108,
      3.543886,
      0,
      NULL,
      1.785324,
      3.353491,
      1.260735,
      1.542085,
      0,
      NULL,
      NULL,
      0.177655,
      1,
      0.282015,
      1,
      NULL,
      1,
      NULL,
      0,
      0.005418,
      0,
      0,
      NULL,
      0.452272,
      0.306467,
      0.492720,
      NULL,
      1.420286,
      2.294075,
      0.718714,
      1.009963,
      NULL,
      2.058553,
      1.453971,
      1.820010,
      1,
      3,
      0,
      1.209223,
      0.276653,
      1,
      1.415819,
      0.550476,
      1,
      NULL,
      0,
      3.726720,
      0.771155,
      1,
      1.805234,
      0,
      0,
      0.363612,
      0.875746,
      3,
      0.906931,
      1,
      0.434083,
      NULL,
      0,
      3.568767,
      1.927237,
      1.977748,
      0,
      0.356426,
      0,
      NULL,
      1,
      1,
      0.312267,
      1,
      0,
      0,
      0.581394,
      0,
      1.691244,
      0,
      0.759843,
      1,
      1.179395,
      0,
      0,
      0,
      3,
      NULL,
      2.868858,
      0,
      0.324313,
      1,
      1.501954,
      0.784518,
      2,
      1.947157,
      '',
      '',
      ' 0-13-1980');
commit;
end;
/


