set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7114559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4243304',
      0,
      2,
      NULL,
      0.380062,
      2,
      3,
      19.904786,
      18,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.136114,
      3.901549,
      3.461936,
      1.522779,
      3.433223,
      0.306514,
      3.849037,
      1.052267,
      NULL,
      1,
      1.184024,
      1.000307,
      2,
      0,
      NULL,
      1.215196,
      0,
      1.525153,
      3.169107,
      1,
      1.812918,
      1.201483,
      1,
      0.247648,
      1,
      0,
      NULL,
      3.803715,
      0.913370,
      0.607356,
      1.941419,
      1,
      0.600855,
      0,
      0,
      1.987921,
      0.532048,
      1.516503,
      1.545232,
      0,
      3,
      1,
      0,
      NULL,
      0,
      1.706995,
      NULL,
      0,
      NULL,
      0.688438,
      0,
      0,
      0.138830,
      1.185947,
      NULL,
      1.973829,
      3.248619,
      1,
      3,
      2.414814,
      2,
      0,
      1,
      1,
      1.936688,
      NULL,
      3.931032,
      0.834032,
      1,
      3,
      NULL,
      1,
      0,
      0.153866,
      1,
      0.192755,
      NULL,
      1,
      1,
      NULL,
      0.762853,
      1,
      1,
      0,
      1,
      3.120068,
      3,
      NULL,
      0,
      0,
      0,
      12.221254,
      0.584635,
      '',
      '',
      ' 3-10-1975');
commit;
end;
/


