set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000195';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0213233',
      3,
      1,
      30,
      0,
      3,
      NULL,
      31,
      89.506083,
      0,
      0.925408,
      1.886902,
      3.549335,
      2,
      1,
      1,
      NULL,
      1.859292,
      0.730089,
      1.553590,
      0,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      0.911034,
      0,
      1.704882,
      1,
      0,
      1,
      1,
      1.378645,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      2.076397,
      1,
      2,
      1,
      0,
      0,
      0.598816,
      1.242345,
      1.982579,
      0,
      0,
      NULL,
      1,
      3.174319,
      NULL,
      NULL,
      0,
      0,
      0.220942,
      0,
      0,
      0.126355,
      3,
      1.269500,
      0,
      1.516887,
      0.350104,
      3.016938,
      3.377336,
      1.725759,
      2,
      0,
      NULL,
      0.799523,
      0,
      0.010623,
      1.283013,
      NULL,
      1.696125,
      0,
      NULL,
      0,
      0,
      1.412436,
      1,
      NULL,
      2.805203,
      1,
      0,
      0.905863,
      1.594875,
      3,
      1,
      3.390193,
      3.627649,
      0,
      2,
      1.355653,
      0,
      11.931028,
      5.387282,
      '',
      '',
      ' 9- 5-1987');
commit;
end;
/


