set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226375';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      1,
      32.454688,
      2.986639,
      NULL,
      NULL,
      NULL,
      17,
      3,
      NULL,
      3.370554,
      NULL,
      2,
      0.606911,
      1,
      NULL,
      1,
      1,
      1.386285,
      0.576036,
      0,
      1.740531,
      NULL,
      3.977817,
      NULL,
      2,
      0,
      NULL,
      0.069830,
      NULL,
      1.497282,
      0,
      0,
      1.133118,
      0.295028,
      1,
      1,
      1.922978,
      NULL,
      2,
      1.784829,
      1,
      3.816455,
      1,
      NULL,
      2.959905,
      2,
      NULL,
      1,
      2.597685,
      0,
      1,
      0,
      0.879206,
      1,
      1,
      0.346261,
      NULL,
      3.509715,
      NULL,
      0,
      0.960405,
      0.538830,
      1,
      0.603750,
      NULL,
      1,
      0.055771,
      1.347573,
      0.407875,
      1.024451,
      0.359504,
      NULL,
      3.103695,
      NULL,
      2.226540,
      1.892775,
      0,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1.052168,
      0,
      1,
      NULL,
      1.152782,
      0,
      2,
      1,
      1,
      0,
      0,
      3.881606,
      0,
      NULL,
      2.627916,
      0,
      2.020259,
      0.343524,
      1,
      4.359623,
      5.093757,
      '402',
      '021',
      NULL);
commit;
end;
/


