set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624278';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2243301',
      3,
      2,
      34,
      NULL,
      1.545478,
      1.758411,
      19.394477,
      0,
      0,
      2.665637,
      1.982771,
      0.310850,
      1,
      0,
      0.435851,
      3.385785,
      0.408563,
      NULL,
      1,
      2.992239,
      0.204428,
      NULL,
      1,
      2.490635,
      0,
      0,
      0.411580,
      1.980351,
      NULL,
      NULL,
      2,
      0,
      1.208331,
      1,
      0.947761,
      NULL,
      1.844119,
      1.035594,
      0,
      1,
      NULL,
      0.437785,
      2.165089,
      3.373987,
      0.677444,
      0,
      3.246938,
      0.282441,
      0,
      0.461788,
      0,
      1.153154,
      2.510514,
      0.544142,
      1,
      1.863301,
      1,
      1.259545,
      0.141248,
      2,
      0.590155,
      1.759010,
      1.507374,
      0.118425,
      0,
      3,
      1,
      1.319450,
      0,
      3,
      1.534223,
      0.679855,
      NULL,
      0.302147,
      1.861847,
      0.616567,
      0,
      1.514235,
      NULL,
      0.237053,
      1,
      0,
      2,
      0.858517,
      0,
      0.401533,
      0.439477,
      0.154002,
      1,
      NULL,
      NULL,
      3.184037,
      3.154372,
      0.071262,
      0,
      0,
      1,
      NULL,
      1.254359,
      0.184751,
      2,
      3.593927,
      1.718392,
      0,
      32,
      23.403347,
      '',
      '',
      ' 5-29-2002');
commit;
end;
/


