set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8820929';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0023333',
      1.909430,
      NULL,
      23,
      3,
      NULL,
      NULL,
      NULL,
      50,
      1.005083,
      NULL,
      1.547708,
      NULL,
      NULL,
      0,
      1,
      2.632431,
      0.170723,
      NULL,
      0.215402,
      1.132318,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.256939,
      0.997531,
      NULL,
      NULL,
      1,
      0,
      1.261469,
      NULL,
      0.606723,
      2,
      1,
      NULL,
      1.183086,
      3,
      2.947001,
      0,
      2.220848,
      2.050413,
      0,
      1.263910,
      1,
      1,
      NULL,
      1.935516,
      NULL,
      1.193522,
      0.750359,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      3.813856,
      0.232705,
      0,
      1.312668,
      1,
      NULL,
      0.932939,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      0.365190,
      1,
      0.369248,
      1.003448,
      1.415652,
      1.929180,
      0.968604,
      0.460108,
      0,
      1,
      1.223065,
      NULL,
      NULL,
      0.924750,
      0,
      0.889555,
      1.830702,
      0.392834,
      0.987754,
      0.320143,
      1.655955,
      1,
      NULL,
      1.740437,
      3,
      0.574355,
      NULL,
      0,
      1.095413,
      3,
      0,
      0.316724,
      1,
      1.306094,
      '',
      '',
      ' 0- 8-1974');
commit;
end;
/


