set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6601436';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2040021',
      NULL,
      1,
      20,
      3.282086,
      1,
      3.944612,
      6,
      8,
      3.322332,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      2.693387,
      0.733496,
      1,
      2.494994,
      NULL,
      2,
      3.064081,
      2.882083,
      2,
      0.388927,
      3,
      2.736488,
      2.462303,
      0,
      3.737789,
      1,
      NULL,
      0.878732,
      0.495807,
      NULL,
      2,
      0,
      2.212198,
      1,
      0.817195,
      3.246484,
      3,
      3.860545,
      0,
      3.960692,
      0.652387,
      NULL,
      3.243466,
      NULL,
      3,
      NULL,
      0.371789,
      0.127648,
      1,
      0,
      1.438166,
      NULL,
      3,
      0,
      3,
      1.003967,
      1.884791,
      0,
      0.778352,
      1,
      3.809901,
      3,
      3.786255,
      1,
      1,
      NULL,
      0,
      2,
      3,
      1,
      1.049533,
      0,
      3.059288,
      1,
      1.885100,
      NULL,
      1,
      2.127684,
      NULL,
      NULL,
      1.500284,
      2,
      NULL,
      3.674347,
      1,
      0.484728,
      3,
      1.926889,
      NULL,
      3,
      0,
      3.659238,
      1.979081,
      1,
      NULL,
      3,
      0,
      0.712252,
      NULL,
      16.820892,
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


