set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7934488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1441131',
      1,
      2,
      27,
      NULL,
      NULL,
      4.872371,
      15,
      32.444242,
      0,
      1,
      0.238961,
      3.778018,
      0,
      0.555769,
      NULL,
      2,
      1,
      1,
      0.039645,
      0,
      NULL,
      1.609737,
      1,
      1,
      1.365389,
      1.389618,
      1.949135,
      NULL,
      NULL,
      3.736273,
      NULL,
      1.129638,
      1,
      NULL,
      0,
      1,
      1.213465,
      NULL,
      0.647880,
      3.545672,
      0,
      3.700884,
      NULL,
      1,
      0.528890,
      3.316273,
      0,
      2,
      0,
      0.560851,
      NULL,
      NULL,
      1.293787,
      2.486792,
      0.606643,
      0.311149,
      NULL,
      0.632589,
      1,
      0.453013,
      NULL,
      1.523971,
      1.357527,
      1.650276,
      NULL,
      3.975176,
      0.959592,
      2,
      1,
      1,
      NULL,
      0.314249,
      1,
      NULL,
      0,
      NULL,
      1.549011,
      1,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1.152745,
      0,
      0,
      1.107252,
      0.222189,
      NULL,
      1.830461,
      0.989173,
      1.110582,
      2.214987,
      0.514518,
      NULL,
      1.756499,
      3,
      3.679409,
      1.439981,
      3.574477,
      1,
      NULL,
      NULL,
      3,
      '',
      '',
      ' 4-20-1980');
commit;
end;
/


