set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000159';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4140300',
      1,
      2,
      4.676747,
      0.330795,
      0,
      2.706176,
      46.515662,
      32.531769,
      2.350689,
      NULL,
      1,
      3,
      0.590009,
      1,
      2,
      2.805442,
      0.159976,
      1.700769,
      0,
      0.926392,
      0,
      1,
      3.665200,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994721,
      NULL,
      0,
      3.199464,
      0.636985,
      NULL,
      1.290754,
      1,
      1,
      1,
      0.218404,
      3.538809,
      NULL,
      0.144499,
      NULL,
      1,
      3,
      NULL,
      0.757729,
      2,
      0.004450,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      3.333695,
      NULL,
      2,
      0.565546,
      0,
      1.526655,
      0.634678,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.980489,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0.486627,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0,
      1,
      1.665806,
      3.652049,
      0.424620,
      NULL,
      0.900001,
      NULL,
      1.006015,
      0,
      0,
      1.086482,
      3,
      1.667103,
      3,
      2,
      3.123887,
      3.843301,
      3,
      2.095371,
      3.946496,
      14,
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


