set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000105';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0423214',
      3.921140,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      64,
      0.821301,
      NULL,
      0,
      1,
      0.261013,
      1.459064,
      0,
      3,
      1,
      1.473805,
      2,
      3.303720,
      1.442595,
      NULL,
      0.693356,
      3.729245,
      0,
      NULL,
      1.140594,
      1.459637,
      NULL,
      0,
      1.951829,
      1,
      1.189268,
      NULL,
      1.404045,
      2.767957,
      0,
      1,
      1.710893,
      NULL,
      NULL,
      3.752416,
      3.941254,
      0,
      0.616504,
      1,
      0,
      NULL,
      NULL,
      3.322066,
      NULL,
      0.868471,
      0.961492,
      0.131673,
      0,
      NULL,
      1,
      0,
      3,
      1.944029,
      0.724960,
      1.586450,
      0.966871,
      0.251996,
      0.337065,
      2,
      1,
      0,
      1.036881,
      0,
      NULL,
      1,
      0,
      NULL,
      1.398492,
      1,
      1.871709,
      1,
      NULL,
      0.237702,
      0.949535,
      1,
      0,
      1.114643,
      NULL,
      1,
      NULL,
      1,
      1.889224,
      0,
      1,
      0,
      0.604747,
      1,
      0.451224,
      0,
      3.775673,
      1.639592,
      1,
      NULL,
      2,
      3,
      0.254054,
      NULL,
      21.095023,
      5,
      NULL,
      '',
      ' 7-23-1983');
commit;
end;
/


