set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0311330',
      2,
      0,
      8.539995,
      NULL,
      NULL,
      0,
      61.746119,
      54,
      1,
      0.988984,
      NULL,
      NULL,
      0.027942,
      1.008667,
      2,
      1,
      NULL,
      0.575342,
      1.049622,
      0,
      1,
      1,
      1.266744,
      0.048943,
      0,
      1,
      1.738097,
      0.248352,
      1,
      1.165319,
      NULL,
      1.952320,
      1.681773,
      0,
      NULL,
      0.722726,
      1,
      1.576060,
      1.358398,
      1,
      NULL,
      1.746918,
      1,
      0,
      1.981548,
      3.035757,
      0.649460,
      2.811347,
      1,
      NULL,
      1.089410,
      0,
      1,
      0,
      0.994813,
      1,
      NULL,
      0,
      3.965264,
      NULL,
      1.665852,
      NULL,
      0,
      NULL,
      0,
      3.896346,
      1.320595,
      0.080696,
      0.132159,
      1.931697,
      0.920661,
      1,
      0,
      1.814213,
      0.805861,
      1,
      1.739447,
      0,
      0.955088,
      1,
      1,
      1,
      1.633328,
      3,
      1.566176,
      0.282595,
      0,
      0,
      1,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.981276,
      0,
      0,
      2,
      1,
      0,
      NULL,
      5,
      '',
      '',
      ' 2-19-1974');
commit;
end;
/


