set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8520975';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4331034',
      1.420624,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.401251,
      1.890029,
      NULL,
      0.588002,
      1,
      0,
      NULL,
      0,
      1.511842,
      NULL,
      1.162168,
      0,
      0.365982,
      1.265556,
      NULL,
      0.442821,
      0.270768,
      1,
      NULL,
      1,
      1,
      1.491931,
      2.689731,
      1.384730,
      1.572527,
      1.136912,
      0,
      0.270945,
      0.802682,
      1.028069,
      1.133463,
      1.863520,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0.724430,
      NULL,
      3,
      0,
      0.012741,
      2,
      NULL,
      0,
      3,
      1,
      1.269074,
      0,
      1,
      1.238164,
      2.047303,
      1,
      1,
      1,
      1.729885,
      1.402578,
      0,
      2,
      0,
      0,
      2.261728,
      1,
      1,
      1,
      1,
      1.451958,
      1.605425,
      NULL,
      1,
      1.787204,
      0.764723,
      1.272742,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.366336,
      1.768184,
      2.473162,
      NULL,
      1.524019,
      NULL,
      NULL,
      2,
      1.794650,
      3.136107,
      NULL,
      3,
      '',
      '',
      '11-23-2002');
commit;
end;
/


