set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'chapman';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8322808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_chapman_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3034440',
      2,
      1,
      28.578332,
      3.385928,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.706303,
      0,
      1,
      1.352550,
      1,
      2,
      NULL,
      0,
      1.187513,
      NULL,
      NULL,
      NULL,
      0.627070,
      3.882605,
      1,
      0.526970,
      0,
      0,
      NULL,
      2.800759,
      1.949946,
      0,
      0,
      NULL,
      1.479907,
      1,
      1,
      1,
      1,
      1.073505,
      NULL,
      3,
      2,
      0,
      0,
      1.281954,
      0.582614,
      0.348443,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.786101,
      NULL,
      1,
      0,
      0,
      3,
      3.512507,
      NULL,
      NULL,
      0,
      NULL,
      3.103009,
      0,
      1.779502,
      NULL,
      0,
      1,
      0,
      0.072659,
      2,
      0.285454,
      NULL,
      3,
      1.694109,
      0,
      NULL,
      0.547295,
      0,
      1,
      0,
      NULL,
      1.582832,
      0,
      1,
      1.543786,
      0.555250,
      1,
      NULL,
      1.808895,
      NULL,
      1.339507,
      0.435056,
      0.237670,
      NULL,
      0.064722,
      0.873725,
      1,
      0,
      0.412077,
      1,
      0.572823,
      12.393804,
      NULL,
      NULL,
      '',
      ' 8-11-1983');
commit;
end;
/


