
--Add cogbat
create or replace procedure cogbat(username varchar2, v_sec_class varchar2)
is
  v_id1 number;
  v_id2 nc_ontologyconcept.conceptid%TYPE;
  owner_id number;
BEGIN

owner_id := get_database_user_id(username);

v_id1 := add_assessment('cogbat', 'cogbat', owner_id, owner_id);

if v_id1 < 0 then
  Raise_application_error(-20113,'assessment ID is not valid');
end if;

select min(conceptid) into v_id2 from nc_ontologyconcept where ontologysource='UMLS';

add_assessment_score(v_id1, owner_id, owner_id, 'CO205', 112, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 3 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO204', 105, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 4 - # COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO207', 114, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 3 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO206', 113, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 3 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO201', 102, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 3 - # OMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO200', 83, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R SHORT FORM?');

add_assessment_score(v_id1, owner_id, owner_id, 'CO203', 104, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 4 - # OMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO202', 103, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 3 - # COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO137', 309, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO209', 116, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 4 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO208', 115, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 4 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO24', 122, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO25', 238, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO26', 61, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: INFO RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO27', 62, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: INFO SCALED SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'mentrot', 27, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MENT ROT SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO21', 109, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO22', 110, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO23', 111, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'wais11', 11, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #11');

add_assessment_score(v_id1, owner_id, owner_id, 'wais10', 10, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #10');

add_assessment_score(v_id1, owner_id, owner_id, 'CO28', 63, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: DIG SPAN RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO29', 64, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: DIG SPAN SCAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO179', 304, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # ROTATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO178', 303, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # SIZE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO177', 302, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # MISPLACEMENTS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO176', 301, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # PERSEVERATIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO175', 300, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # DISTORTIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO174', 299, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # OMISSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO173', 298, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - TOTAL # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO172', 297, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO171', 296, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STICK MEMORY GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO170', 311, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STICK MEMORY DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO270', 214, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD - BOTH HANDS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO271', 215, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'facrecog', 29, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FACE RECOGN SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO61', 245, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # CATEG');

add_assessment_score(v_id1, owner_id, owner_id, 'CO118', 308, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CLOCK SET DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO216', 124, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO217', 125, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - PERS RESPONSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CO214', 121, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT - COMISSION: SD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO215', 123, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO212', 119, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT - HITS: SD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO213', 120, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT - COMISSION: MEAN');

add_assessment_score(v_id1, owner_id, owner_id, 'CO210', 117, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 4 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO211', 118, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT - HITS: MEAN');

add_assessment_score(v_id1, owner_id, owner_id, 'FUPER', 52, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FOLLOW-UP PERIOD');

add_assessment_score(v_id1, owner_id, owner_id, 'REY02', 233, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO218', 126, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - NONPERS ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO219', 127, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - PERS ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO37', 72, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: SIMILAR SCAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO36', 71, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: SIMILAR RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO35', 70, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: COMP SCALED SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO34', 69, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: COMP RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO33', 68, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: ARITH SCALED SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO32', 67, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: ARITH RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO31', 66, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: VOCAB SCALED SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO30', 65, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R VER: VOCAB RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'tap02', 18, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO5', 92, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART RAW ABSTRACT');

add_assessment_score(v_id1, owner_id, owner_id, 'tap01', 17, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO39', 74, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: PIC COMP SCAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO38', 73, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: PIC COMP RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO168', 294, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO68', 251, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 2 CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'cardrot', 26, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CARD ROT SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO122', 158, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - SUM L');

add_assessment_score(v_id1, owner_id, owner_id, 'CO160', 291, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PAIRED ASS - HARD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO161', 292, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PAIRED ASS - TOTAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO163', 293, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PAIRED ASS GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO123', 159, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO164', 216, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST - COPY');

add_assessment_score(v_id1, owner_id, owner_id, 'CO165', 217, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST - IMMED RECALL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO166', 218, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST - DELAY RECALL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO125', 161, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - PERCENT RANK');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT1', 48, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIRST ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'ENT2', 49, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SECOND ENTRY PERSON');

add_assessment_score(v_id1, owner_id, owner_id, 'CO20', 108, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - 3 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO162', 310, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PAIRED ASS DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO223', 131, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 1 - COR ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO222', 130, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 1 - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO221', 129, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO220', 128, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS (1 DECK) - CATEGORIES');

add_assessment_score(v_id1, owner_id, owner_id, 'CO227', 135, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 2 - ITEMS CORR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO226', 134, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 2 - COR ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO225', 133, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 2 - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO224', 132, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 1 - ITEMS CORR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO82', 262, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING - PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO83', 221, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING - TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO229', 137, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 3 - COR ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO228', 136, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 3 - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO86', 223, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA TREE - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO87', 264, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA TREE - # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO84', 222, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO85', 263, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING - GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'reyost02', 39, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'reyost03', 40, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST SKIP OUT FIELD #3');

add_assessment_score(v_id1, owner_id, owner_id, 'rectask', 24, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD RECOGN SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'reyost01', 38, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'ravl02', 23, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'ravl01', 22, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO167', 219, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY OST DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'REY03', 234, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD SKIP OUT FIELD #3');

add_assessment_score(v_id1, owner_id, owner_id, 'CO244', 313, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY - RAW TOTAL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO127', 163, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO92', 267, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA CURVED - # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO1', 57, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DATE TEST BEGINS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO119', 274, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CLOCK SET GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO66', 249, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 1 TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO169', 295, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STICK MEMORY SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO115', 231, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE A DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'hebb', 33, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: HEBBS DIGITS SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO117', 273, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CLOCK SET SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO116', 272, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE A GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO111', 271, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO110', 155, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO113', 229, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE A - # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO112', 228, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE A - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO51', 87, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: PERF IQ');

add_assessment_score(v_id1, owner_id, owner_id, 'CO238', 182, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - FALSE POSITIVE: B');

add_assessment_score(v_id1, owner_id, owner_id, 'CO239', 183, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - FALSE POSITIVE: SA/SB');

add_assessment_score(v_id1, owner_id, owner_id, 'CO234', 173, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 6 INTRUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO235', 175, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 7 INTRUSIONS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO236', 180, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - RECOGNITION HITS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO237', 181, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - RECOGNITIONS MISSES');

add_assessment_score(v_id1, owner_id, owner_id, 'CO230', 138, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 3 - ITEMS CORR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO231', 139, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 4 - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO232', 140, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 4 - COR ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO233', 141, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP TRIAL 4 - ITEMS CORR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO19', 107, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - 2 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO18', 106, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - 1 LATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO99', 144, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO15', 100, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - # OMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO14', 236, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - % COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO17', 237, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - % COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO16', 101, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 2 - # COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'curvelet', 44, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CURVE LETTERS SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO10', 97, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO13', 99, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - # COMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO12', 98, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT TRIAL 1 - # OMITTED');

add_assessment_score(v_id1, owner_id, owner_id, 'DOCNUM', 47, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DOCUMENT NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CO81', 220, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO121', 157, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - SUM F');

add_assessment_score(v_id1, owner_id, owner_id, 'circlea', 45, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE As SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO114', 230, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CIRCLE A - TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO108', 153, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT 5');

add_assessment_score(v_id1, owner_id, owner_id, 'CO109', 154, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT AVERAGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO106', 151, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CO107', 152, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CO104', 149, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO105', 150, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - LEFT 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO102', 147, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT 5');

add_assessment_score(v_id1, owner_id, owner_id, 'CO103', 148, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT AVERAGE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO100', 145, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CO101', 146, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CO249', 193, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MENTAL ROTATIONS - CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO248', 192, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CARD ROTATIONS - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER2', 60, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SECOND CHECKER OF FORM');

add_assessment_score(v_id1, owner_id, owner_id, 'CO241', 186, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY - SUM COMPANY');

add_assessment_score(v_id1, owner_id, owner_id, 'CO240', 184, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - FALSE POSITIVE: PA/PB');

add_assessment_score(v_id1, owner_id, owner_id, 'CO243', 188, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY - SUM WILD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO242', 187, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY - SUM CLEAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO245', 189, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO88', 265, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA TREE - # CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO247', 191, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CARD ROTATIONS - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO246', 190, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CARD ROTATIONS - CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'assflu', 25, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ASS FLUENCY SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO69', 252, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 2 TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO89', 266, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA TREE - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'RATER', 59, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: RATER NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'REL', 53, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: RELIABILITY');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 1, 'Original', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 2, 'Second', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 3, 'Third', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'REL', 4, 'Fourth', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CO60', 244, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # PER ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'logmem01', 20, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO62', 306, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO63', 246, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO64', 247, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 1 ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO65', 248, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 1 CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'ship02', 13, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIPLEY SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO67', 250, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 2 ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'ASS', 51, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: COGNITIVE BATTERY ASSESSMENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO180', 312, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO11', 235, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'logmem02', 21, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO80', 261, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: HANDEDNESS GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO97', 270, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'ID', 50, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SUBJECT ID');

add_assessment_score(v_id1, owner_id, owner_id, 'CO95', 226, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA CURVED - # TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO94', 269, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA CURVED - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO139', 164, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM - TOTAL FREE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO96', 227, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO91', 225, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA CURVED - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO90', 224, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA TREE - # TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO93', 268, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ALPHA CURVED - # CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'ship01', 12, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIPLEY SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO133', 280, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FIXED - # UNACCEPT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO132', 279, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FREE - # PERSEV UNACC');

add_assessment_score(v_id1, owner_id, owner_id, 'CO131', 278, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FREE - # NOVEL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO130', 277, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FREE - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'dichlist', 32, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DICH LISTENING SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO98', 143, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FINGER TAP - RIGHT 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO135', 282, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FIXED - # NOVEL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO134', 281, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FIXED - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO258', 202, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: RECENCY FREQ - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'stroop', 16, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: NEW STROOP SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'VER', 56, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: VERSION NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CO181', 305, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BENTON GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO252', 196, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LINE ORIENTATION - SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO253', 197, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LINE ORIENTATION - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO250', 194, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MENTAL ROTATIONS - ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO251', 195, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MENTAL ROTATIONS - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO256', 200, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: RECENCY FREQ - WORDS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO257', 201, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: RECENCY FREQ - PICTURES');

add_assessment_score(v_id1, owner_id, owner_id, 'FRM', 55, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'NULL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO255', 199, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FACIAL RECOGNITION - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO155', 288, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - QUES REPEATS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO79', 307, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ORIENTATION DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO78', 260, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ORIENTATION');

add_assessment_score(v_id1, owner_id, owner_id, 'trailmak', 42, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TRAIL MAKING SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO73', 256, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 4 ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO72', 255, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 3 TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO71', 254, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 3 CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO70', 253, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 3 ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO77', 259, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO76', 142, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO75', 258, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 4 TIME');

add_assessment_score(v_id1, owner_id, owner_id, 'CO74', 257, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: STROOP TRIAL 4 CORRECTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO124', 160, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - ADJUSTED SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'MED', 54, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"COGBAT2: MEDICATION STATUS(0=NO MED, 1=MED)"');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 0, 'No medication', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'MED', 1, 'Medication', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'CO126', 162, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - INTERPRET');

add_assessment_score(v_id1, owner_id, owner_id, 'CO2', 58, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DATE TEST FINISHED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO120', 156, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD - SUM C');

add_assessment_score(v_id1, owner_id, owner_id, 'CO4', 91, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART RAW VOCAB');

add_assessment_score(v_id1, owner_id, owner_id, 'CO7', 94, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART ABSTR AGE EQUIV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO6', 93, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART VOCAB AGE EQUIV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO9', 96, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART WAIS-R EQUIV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO8', 95, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: SHIP-HART CONCEPT QUOTIENT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO128', 275, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE WORD GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO129', 276, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FREE - # UNACCEPT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO136', 283, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU: FIXED - # PERSEV UNACC');

add_assessment_score(v_id1, owner_id, owner_id, 'CO138', 284, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FIG FLU GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'treelet', 43, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: TREE LETTERS SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO46', 81, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: DIGIT SYM RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO47', 82, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: DIGIT SYM SCA SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO44', 79, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: OBJ ASS RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO45', 80, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: OBJ ASS SCAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO42', 77, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: BLOCK DES RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO43', 78, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: BLOCK DES SCA SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO40', 75, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: PIC ARR RAW SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO41', 76, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R PER: PIC ARR SCAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'pegbrd01', 35, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'pegbrd02', 36, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'pegbrd03', 37, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD SKIP OUT FIELD #3');

add_assessment_score(v_id1, owner_id, owner_id, 'CO48', 84, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: SCALED VERBAL SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO49', 85, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: VERBAL IQ');

add_assessment_score(v_id1, owner_id, owner_id, 'CO259', 203, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DICH LISTENING - RIGHT EAR');

add_assessment_score(v_id1, owner_id, owner_id, 'recfreq1', 30, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REC FREQ SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'recfreq2', 31, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REC FREQ SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO151', 176, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, '"COGBAT2: REY AUD - TRIAL 1-5,7"');

add_assessment_score(v_id1, owner_id, owner_id, 'CO150', 174, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 7');

add_assessment_score(v_id1, owner_id, owner_id, 'wcs', 15, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WCS SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO152', 177, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TOTAL ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'REY01', 232, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO154', 287, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - CORR REPEATS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO157', 185, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO156', 179, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - DELAYED RECALL');

add_assessment_score(v_id1, owner_id, owner_id, 'CO159', 290, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PAIRED ASS - EASY');

add_assessment_score(v_id1, owner_id, owner_id, 'CO158', 289, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO263', 207, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: HEBBS - # CORRECT (OTHER)');

add_assessment_score(v_id1, owner_id, owner_id, 'addtest', 41, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: ADD TESTS SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'BATCHNUM', 46, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: BATCH NUMBER');

add_assessment_score(v_id1, owner_id, owner_id, 'CO50', 86, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: SCALED PERF SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO53', 89, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: FULL SCALE IQ');

add_assessment_score(v_id1, owner_id, owner_id, 'CO52', 88, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R TOT: FULL SCALE SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO55', 239, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO54', 90, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS-R DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO57', 241, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # ERRORS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO56', 240, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # CORRECT');

add_assessment_score(v_id1, owner_id, owner_id, 'CO59', 243, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # NONPERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO58', 242, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WISC CARD SORT - # PERSEV');

add_assessment_score(v_id1, owner_id, owner_id, 'CO153', 178, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - REPEATS');

add_assessment_score(v_id1, owner_id, owner_id, 'wais08', 8, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #8');

add_assessment_score(v_id1, owner_id, owner_id, 'wais09', 9, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #9');

add_assessment_score(v_id1, owner_id, owner_id, 'mae', 19, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: MAE SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO254', 198, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: FACIAL RECOGNITION - SCORE');

add_assessment_score(v_id1, owner_id, owner_id, 'wais02', 2, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #2');

add_assessment_score(v_id1, owner_id, owner_id, 'wais03', 3, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #3');

add_assessment_score(v_id1, owner_id, owner_id, 'wais01', 1, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #1');

add_assessment_score(v_id1, owner_id, owner_id, 'wais06', 6, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #6');

add_assessment_score(v_id1, owner_id, owner_id, 'wais07', 7, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #7');

add_assessment_score(v_id1, owner_id, owner_id, 'wais04', 4, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #4');

add_assessment_score(v_id1, owner_id, owner_id, 'wais05', 5, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: WAIS SKIP OUT FIELD #5');

add_assessment_score(v_id1, owner_id, owner_id, 'CO142', 166, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO143', 286, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM GAS');

add_assessment_score(v_id1, owner_id, owner_id, 'CO140', 285, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM - TOTAL PROMPTED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO141', 165, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LOG MEM - DELAYED');

add_assessment_score(v_id1, owner_id, owner_id, 'CO146', 169, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 3');

add_assessment_score(v_id1, owner_id, owner_id, 'CO147', 170, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 4');

add_assessment_score(v_id1, owner_id, owner_id, 'CO144', 167, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 1');

add_assessment_score(v_id1, owner_id, owner_id, 'CO145', 168, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 2');

add_assessment_score(v_id1, owner_id, owner_id, 'CO148', 171, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 5');

add_assessment_score(v_id1, owner_id, owner_id, 'CO149', 172, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: REY AUD - TRIAL 6');

add_assessment_score(v_id1, owner_id, owner_id, 'CO267', 211, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CORSI - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO266', 210, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CORSI - # CORRECT (OTHER)');

add_assessment_score(v_id1, owner_id, owner_id, 'CO265', 209, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CORSI - # CORRECT (LEARNING)');

add_assessment_score(v_id1, owner_id, owner_id, 'CO264', 208, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: HEBBS - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'lineort', 28, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: LINE ORIENT SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO262', 206, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: HEBBS - # CORRECT (LEARNING)');

add_assessment_score(v_id1, owner_id, owner_id, 'CO261', 205, 'timestamp', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DICH LISTENING - DATE');

add_assessment_score(v_id1, owner_id, owner_id, 'CO260', 204, 'float', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: DICH LISTENING - LEFT EAR');

add_assessment_score(v_id1, owner_id, owner_id, 'CO268', 212, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD - RIGHT HAND');
add_assessment_code(v_id1, owner_id, owner_id, 'CO268', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO268', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO268', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO268', 3, 'Both', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'cpt', 14, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CPT SKIP OUT FIELD');

add_assessment_score(v_id1, owner_id, owner_id, 'CO269', 213, 'integer', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: PEG BOARD - LEFT HAND');
add_assessment_code(v_id1, owner_id, owner_id, 'CO269', 0, 'ERROR', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO269', 1, 'Right', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO269', 2, 'Left', 'integer');
add_assessment_code(v_id1, owner_id, owner_id, 'CO269', 3, 'Both', 'integer');

add_assessment_score(v_id1, owner_id, owner_id, 'corsi', 34, 'varchar', v_sec_class, 0, NULL, NULL, NULL, 0, 'UMLS', v_id2, NULL, NULL, 1, 1, 1, 0, 1, 0, 'COGBAT2: CORSI BLOCKS SKIP OUT FIELD');

commit;
END;
/
