set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9113816';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0121',
      NULL,
      '22242441',
      NULL,
      '03111021',
      '23044301',
      '13011443',
      '10424332',
      '41304134',
      '44041120',
      '02314344',
      '14042344',
      '20233400',
      '33233032',
      '41121422',
      '13231112',
      NULL,
      '20342103',
      '42434312',
      '33233031',
      '22121332',
      '10234001',
      NULL,
      NULL,
      '03124330',
      NULL,
      '40031313',
      NULL,
      '24033344',
      '03443213',
      '31040211',
      '22244320',
      '04133341',
      '22232120',
      '21130423',
      '00421041',
      '32340321',
      NULL,
      NULL,
      '01023012',
      NULL,
      '02042020',
      NULL,
      '04021334',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '4124323',
      NULL,
      0,
      NULL,
      NULL,
      '240100',
      3.824601,
      NULL,
      ' 5- 0-1995',
      77,
      NULL,
      34,
      19.790167,
      10,
      NULL,
      31,
      21,
      3,
      7,
      7.635402,
      16,
      2,
      17,
      5,
      7.812212,
      4.968494,
      10.053281,
      7,
      19.968760,
      19.473633,
      17,
      51.814126,
      NULL,
      NULL,
      57,
      87,
      10.018168,
      NULL,
      NULL,
      121,
      ' 6- 9-1997',
      NULL,
      12.718604,
      5.020644,
      17.471748,
      129,
      174.999079,
      NULL,
      7,
      1,
      6.899378,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.823268,
      0.346679,
      1.948310,
      1,
      2.690434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-12-1996',
      NULL,
      19.107315,
      6.558928,
      NULL,
      114.234899,
      124.091452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1984',
      16.965295,
      0.616837,
      NULL,
      3.733501,
      63,
      NULL,
      5,
      NULL,
      12,
      13.072224,
      NULL,
      3.039114,
      15,
      11.548229,
      NULL,
      13,
      15,
      NULL,
      4,
      NULL,
      102,
      NULL,
      NULL,
      0.507807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-22-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      36,
      30.194363,
      ' 0-21-2000',
      1,
      NULL,
      NULL,
      12,
      19,
      8.220855,
      NULL,
      '11-14-1983',
      24.129322,
      1.738354,
      43.870143,
      ' 9-20-2003',
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7,
      NULL,
      29.301489,
      124.813373,
      6.514711,
      25,
      10.081730,
      8.083645,
      0,
      1.687969,
      0,
      0,
      92,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      24,
      4,
      5.455525,
      235,
      53.903246,
      25.114814,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      0.838509,
      53,
      21.413569,
      36,
      14,
      3.367790,
      9.438424,
      1.304281,
      0.413366,
      36.150231,
      0,
      1,
      9.180383,
      34.812513,
      0,
      11,
      0,
      23.546181,
      NULL,
      1,
      43,
      6.377920,
      9.245128,
      17.993506,
      14,
      21.571711,
      NULL,
      42.178404,
      3,
      5.831327,
      1,
      1.408174,
      2.104556,
      NULL,
      0.726683,
      NULL,
      31,
      ' 6-17-1986',
      '10-12-1991',
      ' 5-28-2002',
      ' 1- 0-2000',
      ' 5-25-2001',
      NULL,
      ' 3- 3-1979',
      NULL);
commit;
end;
/


