set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8720709';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '02333210',
      '10001304',
      '33201323',
      '30443010',
      '31420411',
      '43011001',
      NULL,
      '22330102',
      '30023202',
      NULL,
      '11021400',
      '24101103',
      '02012334',
      '13011132',
      '22224001',
      '21034240',
      '22301442',
      '13120400',
      '00414402',
      '43330400',
      '42144412',
      '12133131',
      '33310213',
      '33414340',
      '41440311',
      NULL,
      '01021334',
      '42124041',
      '22400424',
      '21330143',
      '20333121',
      NULL,
      NULL,
      '23224113',
      '30103224',
      NULL,
      '43032441',
      '31243030',
      '32112202',
      NULL,
      NULL,
      '11141220',
      '03104200',
      NULL,
      NULL,
      NULL,
      NULL,
      '4044401',
      2.318619,
      1.342347,
      NULL,
      NULL,
      NULL,
      2.555988,
      ' 1-25-1991',
      ' 9- 5-1990',
      39.848440,
      NULL,
      34,
      16.101765,
      6,
      11.832471,
      76.290832,
      NULL,
      4,
      19,
      25.659792,
      9,
      16,
      12.887728,
      37,
      3.303114,
      NULL,
      2.039935,
      8,
      5,
      40,
      11,
      NULL,
      12.825514,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      225.692903,
      185.745799,
      ' 8-22-1980',
      11.587445,
      7.847541,
      3,
      21,
      NULL,
      196,
      ' 1-21-1986',
      1,
      0,
      1.181907,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019701,
      1,
      NULL,
      0.905917,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      NULL,
      0,
      93.967254,
      88,
      2.983779,
      89.305732,
      59.230727,
      73.865851,
      20.971337,
      NULL,
      45.316338,
      ' 6-20-1977',
      2.419620,
      7.016577,
      19.361923,
      28.362754,
      5,
      35.335953,
      2,
      ' 9-10-1975',
      43.446530,
      5.873593,
      ' 7- 3-2002',
      3.206126,
      3.646783,
      23.877688,
      9.639610,
      24.032011,
      NULL,
      NULL,
      17,
      NULL,
      95.606221,
      4.823459,
      2.021255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-10-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019434,
      NULL,
      '10-25-1992',
      1.844516,
      104.978330,
      '11- 7-1985',
      15,
      19,
      15,
      NULL,
      NULL,
      61.208515,
      1,
      14.852170,
      ' 4- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      33.594796,
      NULL,
      NULL,
      NULL,
      3,
      0.504189,
      18.374401,
      NULL,
      2,
      9.871651,
      NULL,
      0,
      1.970008,
      17,
      1.438902,
      2.293625,
      75,
      0,
      3,
      5,
      2.955225,
      0.544681,
      54,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.814328,
      NULL,
      0.715981,
      1,
      1.776449,
      1.083176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.576806,
      NULL,
      NULL,
      NULL,
      2.261741,
      NULL,
      NULL,
      12,
      NULL,
      12,
      3.689570,
      1,
      2,
      0,
      0.544134,
      0.071262,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1997',
      NULL,
      NULL,
      NULL,
      ' 3- 6-1999',
      NULL,
      NULL);
commit;
end;
/


