set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14233232',
      '00314030',
      '30332221',
      '23422321',
      '32024444',
      '43342200',
      '22421244',
      NULL,
      '44432221',
      NULL,
      '24231311',
      '31042413',
      '10212012',
      '11131041',
      '23134442',
      '00101410',
      '32401444',
      '04334422',
      NULL,
      '40400114',
      '44311034',
      '32320441',
      '14241004',
      '01320333',
      '03230401',
      '40140340',
      '13402411',
      '10411133',
      '40212140',
      '21434040',
      '03112242',
      '40242401',
      '44424124',
      '32103303',
      '12133343',
      '42121234',
      '42144103',
      '22411241',
      NULL,
      NULL,
      '02411112',
      '30144401',
      '01220400',
      '02101211',
      NULL,
      NULL,
      33,
      14,
      '1144131',
      3,
      0,
      2,
      NULL,
      '324320',
      NULL,
      ' 9- 4-1993',
      ' 7-23-1996',
      75,
      NULL,
      14,
      6.799806,
      16,
      8,
      NULL,
      NULL,
      0,
      4.046043,
      26.270042,
      4.151053,
      22.989960,
      6,
      NULL,
      NULL,
      3.790639,
      NULL,
      30,
      0.644877,
      52,
      14,
      24.062453,
      14.987503,
      1,
      53.024352,
      146,
      28,
      153,
      175.500569,
      126.457268,
      ' 2- 5-1981',
      2,
      24,
      29.448325,
      20.967805,
      NULL,
      176,
      ' 1-19-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9.778797,
      2,
      5,
      ' 8- 1-1989',
      0.876932,
      2.166899,
      91.820286,
      0.124037,
      NULL,
      126,
      NULL,
      0,
      85,
      NULL,
      NULL,
      NULL,
      ' 4- 3-1995',
      NULL,
      88,
      NULL,
      49.706886,
      18,
      55,
      81,
      NULL,
      NULL,
      36,
      41.479356,
      NULL,
      ' 2-15-1999',
      20.796853,
      11.354043,
      14,
      61,
      16.808273,
      61,
      NULL,
      ' 4-17-1978',
      1.755796,
      1,
      ' 7-27-1989',
      2.091721,
      3.216795,
      7.732518,
      3.461798,
      7.568865,
      2,
      0,
      5.908476,
      2,
      43.019393,
      3,
      1.241218,
      4,
      11.828429,
      NULL,
      0.096936,
      0,
      8,
      ' 3-20-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.775970,
      '11-17-1991',
      31.809050,
      NULL,
      0.596624,
      1.562634,
      ' 8-23-1980',
      84,
      60,
      ' 8-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      20.756536,
      ' 9- 6-1984',
      59,
      NULL,
      0,
      ' 0-24-2002',
      3,
      121.800407,
      ' 6-19-1986',
      9.338386,
      28,
      0.791721,
      4,
      ' 6-22-1990',
      42,
      NULL,
      37.693450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


