set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3133',
      '42021021',
      '31431040',
      '03440342',
      '10210241',
      NULL,
      NULL,
      '12422443',
      '02113231',
      '20431241',
      '23001241',
      '34414432',
      '41240141',
      NULL,
      NULL,
      NULL,
      '13021312',
      '32120321',
      NULL,
      NULL,
      '02042420',
      '43140244',
      '12143440',
      NULL,
      '00223414',
      '42243232',
      '23120423',
      '43423334',
      '04211142',
      NULL,
      '24330332',
      '03431243',
      NULL,
      '21222204',
      '03144124',
      '42231412',
      '23004312',
      NULL,
      '43001234',
      '21243040',
      '21002304',
      '33212200',
      '10022234',
      '10333211',
      '41241302',
      '032',
      '01',
      NULL,
      NULL,
      '3122242',
      3,
      0.023558,
      2,
      NULL,
      '213011',
      0,
      ' 5-21-1987',
      ' 4-11-1974',
      48,
      NULL,
      29.044570,
      14,
      NULL,
      12.667145,
      41,
      11,
      NULL,
      14.334831,
      16,
      12.273053,
      10.107729,
      12.670013,
      0,
      2.686583,
      18,
      NULL,
      64.076346,
      15,
      56,
      6,
      26,
      0.606231,
      NULL,
      88,
      88,
      48.039483,
      216.557456,
      212.535494,
      89,
      NULL,
      45.880007,
      NULL,
      17.446720,
      9.562523,
      162,
      23.889410,
      ' 8- 0-1994',
      3,
      0.426262,
      2.537336,
      NULL,
      1.015598,
      NULL,
      6.740533,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.214980,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 4-1990',
      104.544272,
      NULL,
      1.273286,
      5.806452,
      4.590543,
      8.091657,
      '11- 0-1991',
      1,
      NULL,
      133.782341,
      NULL,
      0,
      NULL,
      0,
      4.200898,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-19-1997',
      71.025822,
      47,
      62,
      NULL,
      92.624145,
      62,
      47.421778,
      62,
      NULL,
      60,
      NULL,
      49,
      ' 7- 3-1979',
      15.209113,
      4,
      7,
      42,
      23,
      30.658340,
      NULL,
      NULL,
      2,
      4.275921,
      '11-22-1977',
      12.135181,
      2.679895,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.922346,
      NULL,
      NULL,
      10,
      3.633817,
      0.031676,
      0,
      0,
      0,
      ' 9- 0-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      9,
      '11-24-1996',
      NULL,
      NULL,
      NULL,
      32.146628,
      '11- 7-1983',
      41.523942,
      ' 1-14-1998',
      NULL,
      12,
      ' 3-16-1992',
      NULL,
      78.395175,
      ' 4-26-1978',
      3,
      NULL,
      ' 0-20-1983',
      NULL,
      NULL,
      NULL,
      1,
      2,
      6.071240,
      NULL,
      48,
      NULL,
      45,
      '11- 8-1994',
      0.139186,
      NULL,
      ' 0-12-1994',
      14.723799,
      3,
      6.457803,
      6.061493,
      ' 3- 6-2000',
      31,
      0.972254,
      245,
      ' 9- 9-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


