set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1014',
      '40302323',
      '04201231',
      '11314220',
      '34244002',
      '13202131',
      '20322431',
      '30010134',
      '40011121',
      '34013300',
      '23241411',
      '20211034',
      '13120314',
      NULL,
      '33200101',
      NULL,
      '02124302',
      '33042224',
      '43040420',
      '21401320',
      NULL,
      '14113200',
      '13304432',
      '12211242',
      NULL,
      '43321202',
      '03203403',
      NULL,
      '23021201',
      '21102324',
      NULL,
      '23031344',
      '14004404',
      '41404110',
      '22020041',
      '32231004',
      NULL,
      '02430204',
      NULL,
      '03223204',
      '40342130',
      '43322040',
      '43211440',
      '41200221',
      '42124303',
      '232',
      '34',
      16,
      5,
      '1443424',
      0.499359,
      7.825758,
      1,
      NULL,
      '122101',
      2,
      '11- 1-1981',
      '10-25-1994',
      NULL,
      66,
      9,
      16.066469,
      5.499691,
      15,
      35.384968,
      6,
      3,
      2,
      36,
      17,
      45.925256,
      2.821169,
      NULL,
      NULL,
      26,
      24.905372,
      71,
      3,
      NULL,
      12,
      99,
      21,
      1.772632,
      22,
      90,
      42.495668,
      42,
      184.621025,
      190,
      ' 3- 7-1997',
      16.525147,
      NULL,
      NULL,
      28.577095,
      71.357443,
      175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.284470,
      8.648018,
      6,
      3,
      NULL,
      NULL,
      NULL,
      0,
      196.850222,
      0,
      2.571278,
      101,
      1.797446,
      1,
      16.155381,
      NULL,
      NULL,
      NULL,
      ' 4-25-2001',
      NULL,
      60,
      24,
      25.817429,
      84.240624,
      NULL,
      53.024631,
      20.652330,
      77,
      68.160195,
      NULL,
      33,
      ' 8-16-2000',
      3,
      17,
      NULL,
      NULL,
      35.231161,
      7,
      0,
      '10- 7-2003',
      12.395791,
      13.268958,
      '10-20-1976',
      8,
      7,
      20,
      29,
      3.548321,
      0.724578,
      1,
      0.334481,
      1,
      11.217552,
      0,
      1,
      2,
      NULL,
      0.905313,
      1,
      0.528243,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      113.378371,
      NULL,
      ' 0-24-1993',
      NULL,
      NULL,
      NULL,
      21.084008,
      ' 7-18-1986',
      NULL,
      ' 0-16-1979',
      NULL,
      11.841991,
      NULL,
      2.496990,
      51.975832,
      ' 5-18-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5,
      ' 4-26-1983',
      57,
      70,
      68.148025,
      ' 4- 3-1993',
      0.361191,
      88.292782,
      ' 8-28-1992',
      NULL,
      10.767142,
      3.266879,
      0,
      ' 1-25-1990',
      53,
      1.322312,
      35.620606,
      ' 2-15-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


