set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '3812670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4412',
      '40432232',
      NULL,
      NULL,
      NULL,
      '24243424',
      '03110133',
      '24234122',
      '24342044',
      '30202204',
      '41400324',
      '02331120',
      '23442334',
      '30114342',
      '34223423',
      '10321433',
      '13031230',
      NULL,
      '24110431',
      NULL,
      '42442444',
      '31012034',
      NULL,
      '32444014',
      '34003424',
      NULL,
      '14130131',
      '21414002',
      '24421431',
      '32144231',
      '04133201',
      '31321001',
      '33242342',
      '03121344',
      '04342242',
      '44300431',
      '44231110',
      '11422242',
      '43034040',
      '30321030',
      NULL,
      '31413020',
      NULL,
      '24244341',
      '11200214',
      '',
      NULL,
      NULL,
      NULL,
      '2431020',
      NULL,
      1,
      1,
      NULL,
      '104114',
      1.787357,
      ' 9-26-1976',
      ' 2- 6-1987',
      20,
      NULL,
      NULL,
      13.603420,
      6,
      16,
      20.001296,
      NULL,
      5.385953,
      10,
      NULL,
      20.604097,
      14,
      2.658054,
      NULL,
      18.571630,
      27,
      NULL,
      39.003862,
      6,
      55,
      14,
      52.070278,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      61,
      6.241677,
      NULL,
      NULL,
      NULL,
      1.789658,
      25.991000,
      NULL,
      3.082894,
      107,
      ' 8-16-1976',
      1.292787,
      NULL,
      1.856407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767153,
      1.091586,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1991',
      75.970626,
      111.405690,
      65,
      77.407962,
      NULL,
      NULL,
      20.106697,
      95.743643,
      3,
      12.710602,
      61,
      88,
      '10-20-1986',
      4,
      24,
      6,
      4,
      77.439946,
      NULL,
      3,
      NULL,
      10,
      NULL,
      '11-10-1989',
      5,
      5,
      NULL,
      NULL,
      NULL,
      6.159405,
      NULL,
      20.241827,
      NULL,
      80,
      0.033212,
      NULL,
      8.873755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      11.848162,
      22.131976,
      ' 3- 6-1985',
      NULL,
      5.091331,
      '11- 8-1974',
      6,
      48,
      3.027033,
      0.557297,
      ' 3- 8-2001',
      45,
      0.102981,
      NULL,
      ' 1-25-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      1.898371,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.033991,
      15,
      1,
      3.654717,
      44.244551,
      NULL,
      NULL,
      54.252500,
      NULL,
      28,
      NULL,
      0,
      NULL,
      1.481928,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      NULL,
      0,
      5.731624,
      1.198595,
      NULL,
      4.747170,
      4,
      3,
      NULL,
      1.786070,
      NULL,
      1,
      NULL,
      NULL,
      20.569232,
      6.809959,
      1.382298,
      NULL,
      NULL,
      22.472333,
      NULL,
      10.564259,
      10,
      0.285461,
      7.502271,
      2.062915,
      3,
      1.335213,
      1.677084,
      NULL,
      '11- 0-1994',
      '10-13-1983',
      '11- 9-1986',
      ' 9-16-1974',
      ' 3-25-1980',
      ' 5- 0-1983',
      NULL,
      NULL);
commit;
end;
/


