set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9697746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44302401',
      '23223331',
      '10104211',
      NULL,
      '03212430',
      '40301020',
      '31113023',
      '21200124',
      NULL,
      '11432401',
      NULL,
      '21412333',
      '04421120',
      '04333203',
      '22100004',
      NULL,
      '42334102',
      '24430433',
      '32042141',
      '43243123',
      '02320304',
      '03041044',
      NULL,
      '14020031',
      '30321113',
      NULL,
      '44244102',
      '21044104',
      '34320121',
      NULL,
      '01404434',
      '14434410',
      '44244401',
      '13023321',
      NULL,
      '30334000',
      NULL,
      '03002024',
      '20400323',
      NULL,
      NULL,
      '12433311',
      '02240202',
      '24041403',
      '103',
      '10',
      3,
      22.061333,
      '2202031',
      1,
      NULL,
      2,
      NULL,
      '430433',
      5.321101,
      ' 1- 7-2002',
      NULL,
      NULL,
      89,
      NULL,
      13,
      NULL,
      7.907771,
      47,
      17.110688,
      NULL,
      8.170416,
      30.936261,
      NULL,
      27,
      16.307890,
      25.316647,
      12,
      6.035938,
      3,
      76,
      10,
      30,
      8,
      54,
      1.899884,
      0,
      117,
      66.275518,
      NULL,
      7,
      21.208172,
      186,
      '10-29-1980',
      25.681510,
      18,
      31.963035,
      17,
      59,
      61.428342,
      ' 6- 2-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854309,
      79,
      0,
      1.614131,
      NULL,
      1.163676,
      NULL,
      70.772115,
      NULL,
      NULL,
      NULL,
      NULL,
      87.035338,
      91.130113,
      NULL,
      93.378322,
      2.938026,
      NULL,
      86.584455,
      56,
      69.344189,
      36,
      75.988514,
      59,
      NULL,
      18.211629,
      10,
      3,
      38.177982,
      0,
      5.263479,
      11.204693,
      ' 7-12-1991',
      13.439496,
      7,
      ' 9-24-2003',
      NULL,
      10.842493,
      NULL,
      19,
      22,
      8.594239,
      NULL,
      4.340592,
      1.985409,
      15.678964,
      1,
      2.066591,
      NULL,
      11.717247,
      0,
      3.793588,
      NULL,
      1,
      ' 9-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      25.873978,
      NULL,
      '10- 6-1978',
      NULL,
      NULL,
      NULL,
      45,
      '11-13-1999',
      NULL,
      ' 1-16-1989',
      3.974024,
      NULL,
      ' 2-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      19.402326,
      NULL,
      28.762918,
      NULL,
      25.594960,
      ' 9-22-1989',
      1,
      157.070537,
      ' 6-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


