set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8406340';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4014',
      NULL,
      NULL,
      '32433223',
      '43422344',
      '31220412',
      NULL,
      '14204111',
      '42343223',
      NULL,
      '33040321',
      '33040302',
      '03122221',
      '01111321',
      '41311403',
      '43204401',
      '11234242',
      '42141140',
      '02440443',
      '03302122',
      '31120314',
      '01330330',
      '12413024',
      '44040231',
      NULL,
      '34430204',
      '33420231',
      '30044301',
      NULL,
      '34322102',
      '44402211',
      '30331241',
      '31040120',
      '14211412',
      '13204024',
      '40233410',
      '11233220',
      '01113430',
      '42341340',
      '32321102',
      '14201443',
      '21042133',
      '23441104',
      '44032132',
      '22202220',
      '122',
      NULL,
      NULL,
      NULL,
      '3041114',
      NULL,
      0.742877,
      3,
      NULL,
      '042321',
      1,
      ' 8- 0-1985',
      ' 3-29-2003',
      10.129634,
      NULL,
      30,
      NULL,
      12,
      23,
      100,
      NULL,
      13,
      3.568491,
      33,
      NULL,
      18,
      9,
      27,
      5.359674,
      10.331382,
      NULL,
      20,
      8.726973,
      53,
      6.934140,
      106.678687,
      NULL,
      0.358276,
      NULL,
      13,
      76,
      143,
      80,
      70.364971,
      ' 7-10-1979',
      11.500241,
      21,
      37,
      14,
      110,
      NULL,
      NULL,
      0.166909,
      NULL,
      NULL,
      9.830075,
      NULL,
      NULL,
      1,
      1,
      0.049745,
      0,
      2.992222,
      1.615838,
      NULL,
      4.139627,
      1.213846,
      0,
      3.233390,
      1.589088,
      0.467316,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-27-2002',
      22,
      12,
      26,
      26,
      15.421389,
      0.982822,
      NULL,
      0,
      NULL,
      60.739390,
      NULL,
      NULL,
      124.086105,
      1,
      0.226716,
      68.349988,
      NULL,
      NULL,
      NULL,
      '11-25-1976',
      NULL,
      NULL,
      56.707091,
      14,
      30.584687,
      57,
      38.814958,
      49.834032,
      33.266813,
      NULL,
      66,
      NULL,
      ' 6-12-1977',
      NULL,
      3,
      20.457318,
      NULL,
      37.516544,
      50.184427,
      9.165718,
      NULL,
      0.538256,
      NULL,
      NULL,
      9.739434,
      9,
      14.297708,
      1.036481,
      3.219866,
      NULL,
      0,
      3,
      1.108650,
      73.972931,
      6,
      8.835592,
      5,
      NULL,
      1.461185,
      NULL,
      NULL,
      0.038188,
      ' 7-23-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      9.360580,
      1.602531,
      ' 2-20-1993',
      NULL,
      NULL,
      NULL,
      16,
      ' 5-11-1975',
      34.153037,
      ' 3-22-1993',
      12.168196,
      9.455863,
      ' 0-21-1982',
      83.772964,
      107.641347,
      ' 9- 5-1987',
      4,
      1,
      ' 5-10-1987',
      NULL,
      NULL,
      NULL,
      2,
      3,
      15.267019,
      NULL,
      59,
      12,
      19.979512,
      ' 7-21-2001',
      0,
      87,
      ' 6-19-2002',
      1,
      NULL,
      5,
      NULL,
      ' 7-27-1982',
      64.407732,
      1.528895,
      26.540341,
      ' 9-15-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


