set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8406340';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2000',
      '41303231',
      '30032101',
      '04430231',
      '33302424',
      '41204104',
      '00440402',
      '14301443',
      '12220201',
      '43110004',
      '24020131',
      NULL,
      '00213134',
      '00242120',
      NULL,
      '14043213',
      '40414302',
      '42102403',
      '30040203',
      NULL,
      NULL,
      '32143142',
      '40121301',
      '40441202',
      '11134023',
      '32201442',
      '24032221',
      '00124344',
      '40143401',
      '32412311',
      '20021143',
      '20013112',
      NULL,
      '04014212',
      '44243424',
      '02421202',
      '40040301',
      '43323112',
      '13432122',
      '03432221',
      '01403441',
      NULL,
      '00234142',
      NULL,
      '01230131',
      '124',
      '13',
      24.248269,
      9,
      NULL,
      2,
      30,
      2,
      NULL,
      '003231',
      1.724997,
      ' 7-22-1998',
      ' 5- 7-1995',
      79,
      20.520660,
      NULL,
      1,
      13,
      NULL,
      77,
      23,
      3,
      3.932185,
      37.012170,
      8,
      29.833761,
      18.437673,
      15,
      9.252423,
      NULL,
      5.334892,
      30.229773,
      17,
      1.835126,
      10,
      65,
      NULL,
      0,
      71,
      147,
      NULL,
      97,
      27.530877,
      14.922482,
      NULL,
      NULL,
      25,
      24.827568,
      16,
      90,
      215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.440963,
      16.903178,
      13.494105,
      NULL,
      '10- 7-1989',
      0,
      0.388001,
      NULL,
      0.787032,
      0,
      85,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.010746,
      84,
      6.309023,
      0,
      12,
      46,
      NULL,
      28,
      20.613023,
      4.578892,
      NULL,
      NULL,
      15.178765,
      1.587431,
      9,
      48,
      NULL,
      28.444043,
      6,
      ' 8-28-1974',
      12,
      13,
      ' 8-12-1989',
      7,
      NULL,
      6,
      16.254155,
      1,
      10.275967,
      0,
      13,
      NULL,
      37,
      NULL,
      1.501391,
      15,
      13.655598,
      1.272504,
      1,
      1.851558,
      1,
      ' 9-20-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      72,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      19.691100,
      ' 6-24-1974',
      0.899521,
      ' 2-11-1976',
      13.995290,
      3.127988,
      ' 7- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      14,
      NULL,
      48,
      14.865984,
      17.835217,
      NULL,
      3.808378,
      15.435522,
      '11-10-1994',
      NULL,
      58.374674,
      6,
      72.870718,
      ' 4-24-1978',
      30.352796,
      NULL,
      NULL,
      ' 0-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


