set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8629473';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13012422',
      NULL,
      NULL,
      NULL,
      '20333241',
      '23000130',
      '44221342',
      '13210011',
      '20212010',
      '31213242',
      '23430310',
      '43301140',
      '13012004',
      '33330441',
      '13032303',
      '10122410',
      '33122002',
      '42140141',
      NULL,
      '33410244',
      NULL,
      '12240331',
      '43101022',
      '01044041',
      '12400213',
      '00101320',
      '14103242',
      '11002444',
      NULL,
      NULL,
      NULL,
      '41134011',
      '13111144',
      '43102033',
      NULL,
      '41110023',
      '13212131',
      '22043414',
      '02113024',
      NULL,
      '13433030',
      NULL,
      '44130442',
      NULL,
      NULL,
      '00',
      NULL,
      NULL,
      '4034334',
      0,
      NULL,
      NULL,
      NULL,
      '034402',
      5.786349,
      ' 5-28-1990',
      '11-16-1980',
      103.455420,
      NULL,
      0,
      16.844084,
      2,
      11,
      115.769005,
      NULL,
      25.751224,
      17.547185,
      33,
      5,
      26.020322,
      11.695006,
      NULL,
      21,
      4.610894,
      1,
      17.795047,
      0.423039,
      NULL,
      5.323594,
      114,
      16.051716,
      NULL,
      54.716387,
      54,
      26.943591,
      51,
      110,
      128.671774,
      ' 3-13-1979',
      14,
      NULL,
      17.582229,
      31,
      59,
      101,
      ' 3- 7-2001',
      NULL,
      0,
      NULL,
      0.781415,
      2,
      0.277000,
      NULL,
      1.315664,
      NULL,
      0.431504,
      2,
      0.283072,
      0,
      0,
      0.461907,
      1,
      0.076848,
      0.534467,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-25-1983',
      21,
      1,
      9.878367,
      2.490165,
      1,
      7.712624,
      ' 3-26-1993',
      1,
      1.617976,
      13.691885,
      1.022565,
      NULL,
      14,
      0.857639,
      3.525028,
      46,
      NULL,
      NULL,
      NULL,
      ' 4-20-1999',
      29,
      75,
      109,
      106.792494,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      90.436887,
      0.408064,
      54,
      ' 6-15-1994',
      4,
      20,
      9.225264,
      14,
      25.064534,
      35,
      0.620298,
      ' 8-29-1981',
      NULL,
      NULL,
      ' 3- 3-2000',
      17.055828,
      30,
      9,
      18.891690,
      NULL,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.111972,
      NULL,
      5,
      1,
      NULL,
      1.403072,
      0.067161,
      ' 8-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      1.745604,
      NULL,
      NULL,
      NULL,
      NULL,
      33.653264,
      ' 0- 0-1975',
      53.452691,
      ' 8-13-1992',
      9,
      20.523640,
      ' 1-22-1984',
      14,
      11.587666,
      ' 5-12-1996',
      NULL,
      NULL,
      ' 1- 2-2001',
      NULL,
      NULL,
      NULL,
      1,
      3,
      18,
      NULL,
      36,
      16,
      4,
      '10-16-1996',
      0,
      51.754754,
      ' 9-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


