set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7538176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      '1',
      NULL,
      '1',
      '4',
      '4',
      '0',
      '4',
      '0',
      '4',
      NULL,
      '0',
      '4',
      '2',
      NULL,
      NULL,
      '0',
      '0',
      '4',
      '4',
      NULL,
      '2',
      '',
      '2',
      '',
      '2',
      '2',
      '2',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '2',
      NULL,
      '1',
      '0',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      NULL,
      '441',
      NULL,
      51,
      1.946077,
      NULL,
      0,
      0.380013,
      0,
      NULL,
      '012121',
      5,
      '11-20-2000',
      ' 7-15-1981',
      15.980864,
      32,
      14.561945,
      1.898699,
      NULL,
      17,
      127.511519,
      NULL,
      20.498350,
      17,
      26,
      11.911051,
      45,
      NULL,
      23,
      NULL,
      NULL,
      NULL,
      26,
      20,
      NULL,
      NULL,
      117.053109,
      NULL,
      0.178024,
      NULL,
      133.020866,
      12.203326,
      NULL,
      97.529006,
      168.365396,
      NULL,
      42.587555,
      38,
      NULL,
      28,
      108,
      6.909924,
      ' 8-14-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 6-1994',
      1.726023,
      3.086855,
      NULL,
      1.749179,
      5,
      22.336793,
      NULL,
      0,
      19,
      NULL,
      NULL,
      NULL,
      ' 0- 3-1987',
      6,
      76,
      33.296183,
      72,
      9,
      82.662809,
      65,
      NULL,
      39,
      0.708651,
      NULL,
      18,
      ' 5-15-1993',
      NULL,
      10.098562,
      6,
      63.687616,
      27.896169,
      23,
      10.898283,
      ' 5-19-1997',
      39.059503,
      18,
      ' 2- 4-1990',
      3.940396,
      6.451524,
      NULL,
      21,
      23.172939,
      NULL,
      0.109130,
      0.476073,
      1.567713,
      121.994071,
      11,
      0,
      22.799280,
      12,
      3.558263,
      0.059793,
      NULL,
      1.256441,
      ' 8-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      184.878382,
      1.610503,
      ' 8-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-1998',
      NULL,
      ' 3-23-2003',
      18,
      0.625228,
      NULL,
      NULL,
      109.786909,
      '10- 5-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      25.030051,
      NULL,
      63.383039,
      NULL,
      NULL,
      NULL,
      0.334859,
      55.349044,
      '11-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


