set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8725677';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2311',
      '10441304',
      '34130433',
      '30242212',
      '00312303',
      NULL,
      '34222434',
      '24440313',
      '14244313',
      '00201112',
      NULL,
      NULL,
      '34440312',
      '00203000',
      '00011033',
      '44130401',
      '31403004',
      '11443011',
      '14212443',
      '44144031',
      '02334313',
      NULL,
      '03313003',
      '11331103',
      '31034000',
      '34032231',
      '34132221',
      '41321000',
      '43021200',
      '11443330',
      '42122331',
      '33331130',
      '44100220',
      NULL,
      '42320112',
      '13312203',
      '24341240',
      '12000003',
      '40014412',
      '02303214',
      '02333200',
      '31111441',
      '14331112',
      '44410404',
      '04242112',
      '113',
      '20',
      NULL,
      NULL,
      '0014130',
      0,
      1,
      NULL,
      NULL,
      '414044',
      1.218840,
      NULL,
      ' 3-18-1985',
      124,
      NULL,
      2,
      14.526703,
      23,
      5,
      50,
      21.431148,
      14.776543,
      10.749744,
      NULL,
      3,
      40.952023,
      20.816567,
      1.492174,
      13.116931,
      0,
      14.985922,
      84.927878,
      15,
      38,
      4,
      17,
      1.916072,
      1,
      99.199421,
      151.767305,
      66.260788,
      130.213133,
      97,
      22,
      ' 7-27-1980',
      37.085497,
      3.130938,
      33,
      19.451427,
      76.622505,
      NULL,
      NULL,
      0.347550,
      4,
      1.899407,
      0,
      NULL,
      NULL,
      4.453773,
      NULL,
      1,
      1.822654,
      NULL,
      1.025085,
      1,
      5,
      NULL,
      0.688728,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-25-1989',
      NULL,
      14.279520,
      NULL,
      3,
      8,
      11.825708,
      ' 7-20-1997',
      0,
      1,
      183,
      NULL,
      NULL,
      158,
      NULL,
      3,
      82,
      0,
      1.200516,
      61,
      ' 0- 6-1995',
      122.299736,
      147.136292,
      121,
      NULL,
      142,
      41.845369,
      NULL,
      3.432575,
      76.037448,
      109,
      5.581081,
      25.359309,
      ' 1- 1-1977',
      NULL,
      3.341954,
      10,
      43.536166,
      13,
      20.046354,
      4,
      ' 5-14-1990',
      2.425694,
      11,
      NULL,
      7,
      13,
      23.499536,
      10.696273,
      0,
      7.101639,
      0.224206,
      6.700923,
      0.210822,
      14.605396,
      0.418626,
      3,
      3,
      9.011318,
      1.660221,
      0,
      1.462791,
      1,
      ' 7-11-1986',
      NULL,
      NULL,
      NULL,
      ' 5-11-1975',
      193.723677,
      6,
      NULL,
      37,
      11,
      ' 7-11-1998',
      NULL,
      ' 7-21-1977',
      15.642331,
      ' 1- 9-1989',
      3,
      2,
      '11- 7-1996',
      74.229890,
      127.159628,
      ' 0-15-1981',
      4,
      7,
      ' 8-26-1981',
      1,
      3,
      ' 4-12-1996',
      NULL,
      2,
      0.705775,
      NULL,
      6,
      21.502391,
      31.388624,
      ' 7-23-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.147588);
commit;
end;
/


