set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8301799';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      '1',
      '4',
      '4',
      '2',
      '2',
      '0',
      '0',
      '3',
      '',
      NULL,
      '',
      '1',
      '3',
      '2',
      '2',
      '3',
      '',
      '',
      '1',
      NULL,
      '0',
      '0',
      NULL,
      '3',
      NULL,
      '4',
      '0',
      '4',
      NULL,
      '123',
      '10221014',
      23.630196,
      18,
      '3411220',
      1.926129,
      0.190369,
      3,
      1,
      '334431',
      3.139255,
      ' 6- 1-1976',
      ' 5-27-1984',
      234.392843,
      15,
      1,
      NULL,
      37,
      8.444822,
      NULL,
      14.430204,
      21,
      18,
      40.186891,
      6,
      17.486836,
      5,
      32.405841,
      NULL,
      7.892688,
      13,
      NULL,
      NULL,
      19,
      NULL,
      18.784243,
      13.465391,
      0,
      96.751085,
      84,
      39.236100,
      NULL,
      132,
      86.696148,
      ' 2-18-1987',
      NULL,
      37.356808,
      11,
      21.941282,
      226,
      56.469515,
      ' 1- 1-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.373668,
      2.283566,
      13.306506,
      0,
      4,
      ' 1- 8-1990',
      NULL,
      1.344438,
      115.048755,
      3,
      2.756364,
      62,
      NULL,
      1,
      23.706301,
      NULL,
      NULL,
      NULL,
      '10- 1-2002',
      58,
      90,
      NULL,
      85.742385,
      107.554934,
      89,
      NULL,
      12.259403,
      57.153807,
      29,
      27.962071,
      94,
      ' 5-20-1976',
      NULL,
      7,
      5,
      34,
      NULL,
      0.964970,
      NULL,
      ' 4-13-1997',
      30.060284,
      32.118479,
      NULL,
      9.984000,
      3.931288,
      24,
      15,
      19,
      15,
      0,
      0.717799,
      0.536100,
      116,
      0.657839,
      1.392219,
      7.184022,
      18.067211,
      2,
      1.026162,
      1.401651,
      0.388320,
      ' 2- 0-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      ' 2-18-1989',
      29.780340,
      ' 8-21-1984',
      NULL,
      1.646323,
      ' 9-21-1980',
      100.751115,
      50.601610,
      ' 8-19-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      22,
      ' 8-29-1991',
      NULL,
      NULL,
      23.577627,
      ' 6- 3-1975',
      1.443730,
      12.917783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


