set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8933554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2100',
      '41111311',
      '44040442',
      '11230301',
      '02423442',
      '41320430',
      NULL,
      '30122400',
      NULL,
      '04234041',
      '23431402',
      '43023430',
      '31010402',
      '03342433',
      '41423143',
      '33314433',
      '21131201',
      '30233031',
      '10442130',
      '31023430',
      '43241222',
      '04403341',
      '04442412',
      '04212201',
      '33131334',
      NULL,
      '41441031',
      NULL,
      '01112014',
      NULL,
      '14224410',
      '33421132',
      '41124204',
      '20143323',
      '30011012',
      '14222410',
      '11411324',
      '33042400',
      NULL,
      '40403101',
      '23311101',
      NULL,
      NULL,
      '42111122',
      '02000400',
      '033',
      '31',
      5.513023,
      10,
      '2131203',
      1,
      0.995619,
      2,
      NULL,
      NULL,
      NULL,
      ' 8- 5-1993',
      ' 9-23-1996',
      14,
      NULL,
      NULL,
      2,
      18,
      30,
      77,
      4,
      22.077649,
      NULL,
      23,
      NULL,
      0.901056,
      21,
      29.360636,
      6,
      1,
      28,
      78,
      19,
      17.259878,
      19.309669,
      112,
      7,
      1.044230,
      165.533836,
      111,
      74.960371,
      NULL,
      269,
      187,
      ' 9-16-1978',
      18.376057,
      23.311128,
      24,
      4.277041,
      143,
      158,
      ' 7-16-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.125082,
      0,
      1.582795,
      7.795164,
      9.152263,
      7,
      NULL,
      1.191346,
      NULL,
      14.943786,
      NULL,
      5,
      27,
      1,
      5,
      84,
      NULL,
      NULL,
      NULL,
      NULL,
      48.380203,
      83.767018,
      105.329955,
      63.272756,
      98.088331,
      115,
      64,
      43,
      NULL,
      65.029948,
      104,
      87.894560,
      '10- 3-1996',
      NULL,
      26.605299,
      19.148757,
      NULL,
      63.239663,
      78,
      10,
      NULL,
      12,
      33,
      ' 5-17-1993',
      1.540092,
      5,
      5,
      22.177541,
      1,
      13,
      0.107269,
      15,
      1.211295,
      156,
      1,
      0,
      13.444168,
      8.535652,
      NULL,
      1.503674,
      0.724186,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      130,
      2.083538,
      ' 1-22-2003',
      NULL,
      NULL,
      NULL,
      46.011579,
      ' 6-27-1986',
      NULL,
      ' 8-28-1996',
      16,
      13,
      ' 7-23-1982',
      47,
      46,
      '10- 9-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      22.107173,
      ' 7-17-1995',
      33.179879,
      NULL,
      21,
      ' 9- 7-1980',
      1.014271,
      71.681614,
      ' 2-10-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


