set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9803416';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      '1',
      '2',
      '4',
      '4',
      '4',
      '2',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      NULL,
      '4',
      '3',
      '1',
      '3',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '3',
      '',
      '2',
      '3',
      NULL,
      '2',
      '0',
      '',
      '',
      NULL,
      NULL,
      '4',
      NULL,
      '1',
      '2',
      '0',
      '4',
      NULL,
      '4',
      '2',
      '032',
      '42024341',
      34.656651,
      NULL,
      '2300403',
      NULL,
      1,
      2,
      NULL,
      '112214',
      5.153092,
      NULL,
      '11-22-1986',
      47.098496,
      NULL,
      3.989415,
      7.760209,
      28.937235,
      10,
      51.352839,
      NULL,
      NULL,
      6.534926,
      NULL,
      7,
      14,
      4.082316,
      27,
      NULL,
      26.075190,
      10.442874,
      73.131463,
      29.029964,
      8,
      13,
      28.904360,
      6,
      1.223042,
      94.341570,
      NULL,
      13.834400,
      135.023363,
      17.102749,
      75.646197,
      ' 8-16-1974',
      56.483619,
      NULL,
      1.945644,
      0.820120,
      30.661341,
      71,
      '11-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      18.313477,
      NULL,
      NULL,
      4,
      6,
      ' 3-21-1981',
      0.406179,
      0.460846,
      39.373776,
      3.627801,
      1.097321,
      6,
      NULL,
      2.631910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75.400340,
      4,
      NULL,
      NULL,
      10,
      37,
      NULL,
      49.339652,
      1,
      10.198174,
      22.477846,
      14.347838,
      ' 3-24-2001',
      2,
      13,
      9,
      28.443501,
      35.946102,
      3,
      4,
      ' 7-24-1988',
      0,
      11.679745,
      NULL,
      6,
      3,
      3.362928,
      8.959498,
      19,
      7.239889,
      2,
      NULL,
      1,
      NULL,
      0,
      0.329545,
      10,
      NULL,
      0,
      0,
      0,
      0,
      '11- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      95.215790,
      7.763811,
      ' 2- 9-1976',
      NULL,
      NULL,
      NULL,
      2.850503,
      NULL,
      22.371073,
      ' 7- 4-1998',
      NULL,
      9,
      ' 8-12-1992',
      49.122218,
      17,
      ' 7-28-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      23,
      ' 6-11-1990',
      33,
      3.980925,
      35,
      ' 8-12-1988',
      0,
      161,
      ' 0-12-1987',
      NULL,
      62,
      9,
      47,
      '11-20-1987',
      46.331381,
      NULL,
      35.207916,
      ' 7- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


